/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.MySqlResult;
import dev.miku.r2dbc.mysql.MySqlStatement;
import dev.miku.r2dbc.mysql.MySqlStatementSupport;
import dev.miku.r2dbc.mysql.QueryFlow;
import dev.miku.r2dbc.mysql.client.Client;
import dev.miku.r2dbc.mysql.codec.Codecs;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import reactor.core.publisher.Flux;

final class SimpleMySqlStatement
extends MySqlStatementSupport {
    private final Client client;
    private final Codecs codecs;
    private final ConnectionContext context;
    private final String sql;

    SimpleMySqlStatement(Client client, Codecs codecs, ConnectionContext context, String sql) {
        this.client = AssertUtils.requireNonNull(client, "client must not be null");
        this.codecs = AssertUtils.requireNonNull(codecs, "codecs must not be null");
        this.context = AssertUtils.requireNonNull(context, "context must not be null");
        this.sql = AssertUtils.requireNonNull(sql, "sql must not be null");
    }

    @Override
    public MySqlStatement add() {
        return this;
    }

    @Override
    public MySqlStatement bind(int index, Object value) {
        throw new UnsupportedOperationException("Binding parameters is not supported for simple statement");
    }

    @Override
    public MySqlStatement bind(String name, Object value) {
        throw new UnsupportedOperationException("Binding parameters is not supported for simple statement");
    }

    @Override
    public MySqlStatement bindNull(int index, Class<?> type) {
        throw new UnsupportedOperationException("Binding parameters is not supported for simple statement");
    }

    @Override
    public MySqlStatement bindNull(String name, Class<?> type) {
        throw new UnsupportedOperationException("Binding parameters is not supported for simple statement");
    }

    public Flux<MySqlResult> execute() {
        return QueryFlow.execute(this.client, this.sql).map(messages -> new MySqlResult(false, this.codecs, this.context, this.generatedKeyName, (Flux<ServerMessage>)messages));
    }

    @Override
    public MySqlStatement fetchSize(int rows) {
        AssertUtils.require(rows >= 0, "Fetch size must be greater or equal to zero");
        return this;
    }

    public String toString() {
        return "SimpleMySqlStatement{sql=REDACTED}";
    }
}

