/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.authentication;

import dev.miku.r2dbc.mysql.collation.CharCollation;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class AuthHelper {
    private AuthHelper() {
    }

    static byte[] generalHash(String algorithm, boolean leftSalt, CharSequence password, byte[] salt, CharCollation collation) {
        Charset charset = collation.getCharset();
        MessageDigest digest = AuthHelper.loadDigest(algorithm);
        byte[] oneRound = AuthHelper.digestBuffer(digest, charset.encode(CharBuffer.wrap(password)));
        byte[] twoRounds = AuthHelper.finalDigests(digest, new byte[][]{oneRound});
        if (leftSalt) {
            return AuthHelper.allBytesXor(AuthHelper.finalDigests(digest, salt, twoRounds), oneRound);
        }
        return AuthHelper.allBytesXor(AuthHelper.finalDigests(digest, twoRounds, salt), oneRound);
    }

    static byte[] encodeTerminal(CharBuffer chars, Charset charset) {
        ByteBuffer buffer = charset.encode(chars);
        int maxIndex = buffer.remaining();
        byte[] bytes = new byte[maxIndex + 1];
        buffer.get(bytes, 0, maxIndex);
        bytes[maxIndex] = 0;
        return bytes;
    }

    private static MessageDigest loadDigest(String name) {
        try {
            return MessageDigest.getInstance(name);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(String.format("%s not support of MessageDigest", name), e);
        }
    }

    private static byte[] finalDigests(MessageDigest digest, byte[] ... plains) {
        digest.reset();
        for (byte[] plain : plains) {
            digest.update(plain);
        }
        return digest.digest();
    }

    private static byte[] digestBuffer(MessageDigest digest, ByteBuffer buffer) {
        digest.update(buffer);
        return digest.digest();
    }

    private static byte[] allBytesXor(byte[] left, byte[] right) {
        int size = left.length;
        if (size != right.length) {
            throw new IllegalArgumentException(String.format("can not xor different sizes %d and %d", size, right.length));
        }
        for (int i = 0; i < size; ++i) {
            int n = i;
            left[n] = (byte)(left[n] ^ right[i]);
        }
        return left;
    }
}

