/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.authentication;

import dev.miku.r2dbc.mysql.authentication.AuthHelper;
import dev.miku.r2dbc.mysql.authentication.CachingSha2FullAuthProvider;
import dev.miku.r2dbc.mysql.authentication.MySqlAuthProvider;
import dev.miku.r2dbc.mysql.collation.CharCollation;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import reactor.util.annotation.Nullable;

final class CachingSha2FastAuthProvider
implements MySqlAuthProvider {
    static final CachingSha2FastAuthProvider INSTANCE = new CachingSha2FastAuthProvider();
    private static final String ALGORITHM = "SHA-256";
    private static final boolean IS_LEFT_SALT = false;

    private CachingSha2FastAuthProvider() {
    }

    @Override
    public boolean isSslNecessary() {
        return false;
    }

    @Override
    public byte[] authentication(@Nullable CharSequence password, @Nullable byte[] salt, CharCollation collation) {
        if (password == null || password.length() <= 0) {
            return new byte[]{0};
        }
        AssertUtils.requireNonNull(salt, "salt must not be null when password exists");
        AssertUtils.requireNonNull(collation, "collation must not be null when password exists");
        return AuthHelper.generalHash(ALGORITHM, false, password, salt, collation);
    }

    @Override
    public MySqlAuthProvider next() {
        return CachingSha2FullAuthProvider.INSTANCE;
    }

    @Override
    public String getType() {
        return "caching_sha2_password";
    }
}

