/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.client;

import dev.miku.r2dbc.mysql.client.Lifecycle;
import dev.miku.r2dbc.mysql.client.RequestQueue;
import dev.miku.r2dbc.mysql.client.SslState;
import dev.miku.r2dbc.mysql.client.WriteSubscriber;
import dev.miku.r2dbc.mysql.message.client.ClientMessage;
import dev.miku.r2dbc.mysql.message.client.PrepareQueryMessage;
import dev.miku.r2dbc.mysql.message.client.PreparedFetchMessage;
import dev.miku.r2dbc.mysql.message.client.SslRequest;
import dev.miku.r2dbc.mysql.message.header.SequenceIdProvider;
import dev.miku.r2dbc.mysql.message.server.ColumnCountMessage;
import dev.miku.r2dbc.mysql.message.server.CompleteMessage;
import dev.miku.r2dbc.mysql.message.server.DecodeContext;
import dev.miku.r2dbc.mysql.message.server.ErrorMessage;
import dev.miku.r2dbc.mysql.message.server.PreparedOkMessage;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.message.server.ServerMessageDecoder;
import dev.miku.r2dbc.mysql.message.server.ServerStatusMessage;
import dev.miku.r2dbc.mysql.message.server.SyntheticMetadataMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.annotation.Nullable;

final class MessageDuplexCodec
extends ChannelDuplexHandler {
    static final String NAME = "R2dbcMySqlMessageDuplexCodec";
    private static final Logger logger = LoggerFactory.getLogger(MessageDuplexCodec.class);
    private DecodeContext decodeContext = DecodeContext.connection();
    @Nullable
    private SequenceIdProvider.Linkable linkableIdProvider;
    private final ConnectionContext context;
    private final AtomicBoolean closing;
    private final RequestQueue requestQueue;
    private final ServerMessageDecoder decoder = new ServerMessageDecoder();

    MessageDuplexCodec(ConnectionContext context, AtomicBoolean closing, RequestQueue requestQueue) {
        this.context = AssertUtils.requireNonNull(context, "context must not be null");
        this.closing = AssertUtils.requireNonNull(closing, "closing must not be null");
        this.requestQueue = AssertUtils.requireNonNull(requestQueue, "requestQueue must not be null");
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof Lifecycle) {
            if (Lifecycle.COMMAND == evt) {
                this.linkableIdProvider = null;
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof ByteBuf) {
            DecodeContext context = this.decodeContext;
            ServerMessage message = this.decoder.decode((ByteBuf)msg, this.context, context, this.linkableIdProvider);
            if (message != null && this.decodeFilter(message)) {
                ctx.fireChannelRead((Object)message);
            }
        } else if (msg instanceof ServerMessage) {
            ctx.fireChannelRead(msg);
        } else {
            if (logger.isWarnEnabled()) {
                logger.warn("Unknown message type {} on reading", msg.getClass());
            }
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ClientMessage) {
            ((ClientMessage)msg).encode(ctx.alloc(), this.context).subscribe((Subscriber)WriteSubscriber.create(ctx, promise, this.linkableIdProvider));
            if (msg instanceof PrepareQueryMessage) {
                this.setDecodeContext(DecodeContext.prepareQuery());
            } else if (msg instanceof PreparedFetchMessage) {
                this.setDecodeContext(DecodeContext.fetch());
            } else if (msg instanceof SslRequest) {
                ctx.channel().pipeline().fireUserEventTriggered((Object)SslState.BRIDGING);
            }
        } else {
            if (logger.isWarnEnabled()) {
                logger.warn("Unknown message type {} on writing", msg.getClass());
            }
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.decoder.dispose();
        this.requestQueue.dispose();
        if (this.closing.compareAndSet(false, true)) {
            logger.warn("Connection has been closed by peer");
        }
        ctx.fireChannelInactive();
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.linkableIdProvider = SequenceIdProvider.atomic();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.linkableIdProvider = null;
    }

    private boolean decodeFilter(ServerMessage msg) {
        if (msg instanceof ServerStatusMessage) {
            this.context.setServerStatuses(((ServerStatusMessage)msg).getServerStatuses());
        }
        if (msg instanceof ColumnCountMessage) {
            boolean deprecateEof = (this.context.getCapabilities() & 0x1000000) != 0;
            this.setDecodeContext(DecodeContext.result(deprecateEof, ((ColumnCountMessage)msg).getTotalColumns()));
            return false;
        }
        if (msg instanceof CompleteMessage) {
            this.setDecodeContext(DecodeContext.command());
        } else if (msg instanceof SyntheticMetadataMessage) {
            if (((SyntheticMetadataMessage)msg).isCompleted()) {
                this.setDecodeContext(DecodeContext.command());
            }
        } else if (msg instanceof PreparedOkMessage) {
            int parameters;
            PreparedOkMessage message = (PreparedOkMessage)msg;
            int columns = message.getTotalColumns();
            if (columns > -(parameters = message.getTotalParameters())) {
                boolean deprecateEof = (this.context.getCapabilities() & 0x1000000) != 0;
                this.setDecodeContext(DecodeContext.preparedMetadata(deprecateEof, columns, parameters));
            } else {
                this.setDecodeContext(DecodeContext.command());
            }
        } else if (msg instanceof ErrorMessage) {
            this.setDecodeContext(DecodeContext.command());
        }
        return true;
    }

    private void setDecodeContext(DecodeContext context) {
        this.decodeContext = context;
        if (logger.isDebugEnabled()) {
            logger.debug("Decode context change to {}", (Object)context);
        }
    }
}

