/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.TypePredicates;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

final class BigDecimalCodec
extends AbstractClassedCodec<BigDecimal> {
    static final BigDecimalCodec INSTANCE = new BigDecimalCodec();

    private BigDecimalCodec() {
        super(BigDecimal.class);
    }

    @Override
    public BigDecimal decode(NormalFieldValue value, FieldInformation info, Class<? super BigDecimal> target, boolean binary, ConnectionContext context) {
        BigDecimal decimal;
        ByteBuf buf = value.getBufferSlice();
        if (binary) {
            short type = info.getType();
            switch (type) {
                case 4: {
                    return BigDecimal.valueOf(buf.readFloatLE());
                }
                case 5: {
                    return BigDecimal.valueOf(buf.readDoubleLE());
                }
            }
        }
        if (BigDecimal.ZERO.equals(decimal = new BigDecimal(buf.toString(StandardCharsets.US_ASCII)))) {
            return BigDecimal.ZERO;
        }
        if (BigDecimal.ONE.equals(decimal)) {
            return BigDecimal.ONE;
        }
        if (BigDecimal.TEN.equals(decimal)) {
            return BigDecimal.TEN;
        }
        return decimal;
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof BigDecimal;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return new BigDecimalValue((BigDecimal)value);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        short type = info.getType();
        return TypePredicates.isDecimal(type) || 4 == type || 5 == type;
    }

    private static final class BigDecimalValue
    extends AbstractParameterValue {
        private final BigDecimal decimal;

        private BigDecimalValue(BigDecimal decimal) {
            this.decimal = decimal;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeStringifyNumber(this.decimal));
        }

        @Override
        public short getType() {
            return 246;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BigDecimalValue)) {
                return false;
            }
            BigDecimalValue that = (BigDecimalValue)o;
            return this.decimal.equals(that.decimal);
        }

        public int hashCode() {
            return this.decimal.hashCode();
        }
    }
}

