/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.LongCodec;
import dev.miku.r2dbc.mysql.codec.TypePredicates;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

final class BigIntegerCodec
extends AbstractClassedCodec<BigInteger> {
    private static final String LONG_MAX_VALUE = Long.toString(Long.MAX_VALUE);
    static final BigIntegerCodec INSTANCE = new BigIntegerCodec();

    private BigIntegerCodec() {
        super(BigInteger.class);
    }

    @Override
    public BigInteger decode(NormalFieldValue value, FieldInformation info, Class<? super BigInteger> target, boolean binary, ConnectionContext context) {
        if (binary) {
            return BigIntegerCodec.decodeBinary(value, info);
        }
        return BigIntegerCodec.decodeText(value, info);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof BigInteger;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return new BigIntegerValue((BigInteger)value);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        return TypePredicates.isInt(info.getType());
    }

    private static boolean isGreaterThanMaxValue(String num) {
        int length = num.length();
        if (length != LONG_MAX_VALUE.length()) {
            return length > LONG_MAX_VALUE.length();
        }
        return num.compareTo(LONG_MAX_VALUE) > 0;
    }

    static BigInteger unsignedBigInteger(long negative) {
        byte[] bits = new byte[]{0, (byte)(negative >>> 56), (byte)(negative >>> 48), (byte)(negative >>> 40), (byte)(negative >>> 32), (byte)(negative >>> 24), (byte)(negative >>> 16), (byte)(negative >>> 8), (byte)negative};
        return new BigInteger(bits);
    }

    private static BigInteger decodeText(NormalFieldValue value, FieldInformation info) {
        ByteBuf buf = value.getBufferSlice();
        if (info.getType() == 8 && (info.getDefinitions() & 0x20) != 0) {
            String num;
            if (buf.getByte(buf.readerIndex()) == 43) {
                buf.skipBytes(1);
            }
            if (BigIntegerCodec.isGreaterThanMaxValue(num = buf.toString(StandardCharsets.US_ASCII))) {
                return new BigInteger(num);
            }
            return BigInteger.valueOf(BigIntegerCodec.parseUnsigned(num));
        }
        return BigInteger.valueOf(LongCodec.parse(buf));
    }

    private static BigInteger decodeBinary(NormalFieldValue value, FieldInformation info) {
        ByteBuf buf = value.getBufferSlice();
        boolean isUnsigned = (info.getDefinitions() & 0x20) != 0;
        switch (info.getType()) {
            case 8: {
                long v = buf.readLongLE();
                if (isUnsigned && v < 0L) {
                    return BigIntegerCodec.unsignedBigInteger(v);
                }
                return BigInteger.valueOf(v);
            }
            case 3: {
                if (isUnsigned) {
                    return BigInteger.valueOf(buf.readUnsignedIntLE());
                }
                return BigInteger.valueOf(buf.readIntLE());
            }
            case 9: {
                return BigInteger.valueOf(buf.readIntLE());
            }
            case 2: {
                if (isUnsigned) {
                    return BigInteger.valueOf(buf.readUnsignedShortLE());
                }
                return BigInteger.valueOf(buf.readShortLE());
            }
            case 13: {
                return BigInteger.valueOf(buf.readShortLE());
            }
        }
        if (isUnsigned) {
            return BigInteger.valueOf(buf.readUnsignedByte());
        }
        return BigInteger.valueOf(buf.readByte());
    }

    private static long parseUnsigned(String num) {
        long value = 0L;
        int size = num.length();
        for (int i = 0; i < size; ++i) {
            value = value * 10L + (long)(num.charAt(i) - 48);
        }
        return value;
    }

    private static class BigIntegerValue
    extends AbstractParameterValue {
        private final BigInteger value;

        private BigIntegerValue(BigInteger value) {
            this.value = value;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeAsciiString(this.value.toString()));
        }

        @Override
        public short getType() {
            return 15;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BigIntegerValue)) {
                return false;
            }
            BigIntegerValue that = (BigIntegerValue)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

