/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractLobValue;
import dev.miku.r2dbc.mysql.codec.Codec;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.TypePredicates;
import dev.miku.r2dbc.mysql.codec.lob.LobUtils;
import dev.miku.r2dbc.mysql.message.FieldValue;
import dev.miku.r2dbc.mysql.message.LargeFieldValue;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.r2dbc.spi.Blob;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class BlobCodec
implements Codec<Blob, FieldValue, Class<? super Blob>> {
    static final BlobCodec INSTANCE = new BlobCodec();

    private BlobCodec() {
    }

    @Override
    public Blob decode(FieldValue value, FieldInformation info, Class<? super Blob> target, boolean binary, ConnectionContext context) {
        return LobUtils.createBlob(value);
    }

    @Override
    public boolean canDecode(FieldValue value, FieldInformation info, Type target) {
        if (!(target instanceof Class)) {
            return false;
        }
        short type = info.getType();
        if (!TypePredicates.isLob(type) && 255 != type) {
            return false;
        }
        if (!(value instanceof NormalFieldValue) && !(value instanceof LargeFieldValue)) {
            return false;
        }
        return ((Class)target).isAssignableFrom(Blob.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Blob;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return new BlobValue((Blob)value);
    }

    private static final class BlobValue
    extends AbstractLobValue {
        private final AtomicReference<Blob> blob;

        private BlobValue(Blob blob) {
            this.blob = new AtomicReference<Blob>(blob);
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.defer(() -> {
                Blob blob = this.blob.getAndSet(null);
                if (blob == null) {
                    return Mono.error((Throwable)new IllegalStateException("Blob has written, can not write twice"));
                }
                return Flux.from((Publisher)blob.stream()).collectList().doOnNext(writer::writeByteBuffers).then();
            });
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlobValue)) {
                return false;
            }
            BlobValue blobValue = (BlobValue)o;
            return Objects.equals(this.blob.get(), blobValue.blob.get());
        }

        public int hashCode() {
            Blob blob = this.blob.get();
            return blob == null ? 0 : blob.hashCode();
        }

        @Override
        protected Publisher<Void> getDiscard() {
            Blob blob = this.blob.getAndSet(null);
            return blob == null ? null : blob.discard();
        }
    }
}

