/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractLobValue;
import dev.miku.r2dbc.mysql.codec.Codec;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.TypePredicates;
import dev.miku.r2dbc.mysql.codec.lob.LobUtils;
import dev.miku.r2dbc.mysql.collation.CharCollation;
import dev.miku.r2dbc.mysql.message.FieldValue;
import dev.miku.r2dbc.mysql.message.LargeFieldValue;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.r2dbc.spi.Clob;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ClobCodec
implements Codec<Clob, FieldValue, Class<? super Clob>> {
    static final ClobCodec INSTANCE = new ClobCodec();

    private ClobCodec() {
    }

    @Override
    public Clob decode(FieldValue value, FieldInformation info, Class<? super Clob> target, boolean binary, ConnectionContext context) {
        return LobUtils.createClob(value, info.getCollationId(), context.getServerVersion());
    }

    @Override
    public boolean canDecode(FieldValue value, FieldInformation info, Type target) {
        if (info.getCollationId() == CharCollation.BINARY_ID || !(target instanceof Class)) {
            return false;
        }
        short type = info.getType();
        if (!TypePredicates.isLob(type) && 245 != type) {
            return false;
        }
        if (!(value instanceof NormalFieldValue) && !(value instanceof LargeFieldValue)) {
            return false;
        }
        return ((Class)target).isAssignableFrom(Clob.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Clob;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return new ClobValue((Clob)value, context);
    }

    private static class ClobValue
    extends AbstractLobValue {
        private final AtomicReference<Clob> clob;
        private final ConnectionContext context;

        private ClobValue(Clob clob, ConnectionContext context) {
            this.clob = new AtomicReference<Clob>(clob);
            this.context = context;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.defer(() -> {
                Clob clob = this.clob.getAndSet(null);
                if (clob == null) {
                    return Mono.error((Throwable)new IllegalStateException("Clob has written, can not write twice"));
                }
                return Flux.from((Publisher)clob.stream()).collectList().doOnNext(sequences -> writer.writeCharSequences((List<CharSequence>)sequences, this.context.getCollation())).then();
            });
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClobValue)) {
                return false;
            }
            ClobValue clobValue = (ClobValue)o;
            return Objects.equals(this.clob.get(), clobValue.clob.get());
        }

        public int hashCode() {
            Clob clob = this.clob.get();
            return clob == null ? 0 : clob.hashCode();
        }

        @Override
        protected Publisher<Void> getDiscard() {
            Clob clob = this.clob.getAndSet(null);
            return clob == null ? null : clob.discard();
        }
    }
}

