/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.BigDecimalCodec;
import dev.miku.r2dbc.mysql.codec.BigIntegerCodec;
import dev.miku.r2dbc.mysql.codec.BitSetCodec;
import dev.miku.r2dbc.mysql.codec.BlobCodec;
import dev.miku.r2dbc.mysql.codec.BooleanCodec;
import dev.miku.r2dbc.mysql.codec.ByteArrayCodec;
import dev.miku.r2dbc.mysql.codec.ByteBufferCodec;
import dev.miku.r2dbc.mysql.codec.ByteCodec;
import dev.miku.r2dbc.mysql.codec.ClobCodec;
import dev.miku.r2dbc.mysql.codec.Codec;
import dev.miku.r2dbc.mysql.codec.Codecs;
import dev.miku.r2dbc.mysql.codec.DoubleCodec;
import dev.miku.r2dbc.mysql.codec.DurationCodec;
import dev.miku.r2dbc.mysql.codec.EnumCodec;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.FloatCodec;
import dev.miku.r2dbc.mysql.codec.IntegerCodec;
import dev.miku.r2dbc.mysql.codec.LocalDateCodec;
import dev.miku.r2dbc.mysql.codec.LocalDateTimeCodec;
import dev.miku.r2dbc.mysql.codec.LocalTimeCodec;
import dev.miku.r2dbc.mysql.codec.LongCodec;
import dev.miku.r2dbc.mysql.codec.NullParameterValue;
import dev.miku.r2dbc.mysql.codec.PrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.SetCodec;
import dev.miku.r2dbc.mysql.codec.ShortCodec;
import dev.miku.r2dbc.mysql.codec.StringArrayCodec;
import dev.miku.r2dbc.mysql.codec.StringCodec;
import dev.miku.r2dbc.mysql.codec.YearCodec;
import dev.miku.r2dbc.mysql.message.FieldValue;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

final class DefaultCodecs
implements Codecs {
    static final DefaultCodecs INSTANCE = new DefaultCodecs(ByteCodec.INSTANCE, ShortCodec.INSTANCE, IntegerCodec.INSTANCE, LongCodec.INSTANCE, BigIntegerCodec.INSTANCE, BigDecimalCodec.INSTANCE, FloatCodec.INSTANCE, DoubleCodec.INSTANCE, BooleanCodec.INSTANCE, BitSetCodec.INSTANCE, LocalDateTimeCodec.INSTANCE, LocalDateCodec.INSTANCE, LocalTimeCodec.INSTANCE, DurationCodec.INSTANCE, YearCodec.INSTANCE, StringCodec.INSTANCE, EnumCodec.INSTANCE, SetCodec.INSTANCE, StringArrayCodec.INSTANCE, ClobCodec.INSTANCE, BlobCodec.INSTANCE, ByteBufferCodec.INSTANCE, ByteArrayCodec.INSTANCE);
    private final Codec<?, ?, ?>[] codecs;
    private final Map<Class<?>, PrimitiveCodec<?>> primitiveCodecs;

    private DefaultCodecs(Codec<?, ?, ?> ... codecs) {
        this.codecs = AssertUtils.requireNonNull(codecs, "codecs must not be null");
        HashMap primitiveCodecs = new HashMap();
        for (Codec<?, ?, ?> codec : codecs) {
            if (!(codec instanceof PrimitiveCodec)) continue;
            PrimitiveCodec c = (PrimitiveCodec)codec;
            primitiveCodecs.put(c.getPrimitiveClass(), c);
        }
        this.primitiveCodecs = primitiveCodecs;
    }

    @Override
    public <T> T decode(FieldValue value, FieldInformation info, Type type, boolean binary, ConnectionContext context) {
        AssertUtils.requireNonNull(value, "value must not be null");
        AssertUtils.requireNonNull(info, "info must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        AssertUtils.requireNonNull(type, "type must not be null");
        Type target = DefaultCodecs.chooseTarget(info, type);
        if (target instanceof Class && ((Class)target).isPrimitive()) {
            if (value.isNull()) {
                throw new IllegalArgumentException(String.format("Cannot decode null for type %d", info.getType()));
            }
            Class targetClass = (Class)target;
            PrimitiveCodec<?> codec = this.primitiveCodecs.get(targetClass);
            if (codec != null && value instanceof NormalFieldValue && codec.canPrimitiveDecode(info)) {
                return (T)codec.decode((NormalFieldValue)value, info, targetClass, binary, context);
            }
            throw new IllegalArgumentException(String.format("Cannot decode value of type %s for type %d", targetClass, info.getType()));
        }
        if (value.isNull()) {
            return null;
        }
        for (Codec<?, ?, ?> codec : this.codecs) {
            if (!codec.canDecode(value, info, target)) continue;
            Codec<?, ?, ?> c = codec;
            return (T)c.decode(value, info, target, binary, context);
        }
        throw new IllegalArgumentException(String.format("Cannot decode value of type %s for type %d with collation %d", target, info.getType(), info.getCollationId()));
    }

    @Override
    public <T> T decodeLastInsertId(long value, Class<T> type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        if (Byte.TYPE == type || Byte.class == type) {
            return (T)Byte.valueOf((byte)value);
        }
        if (Short.TYPE == type || Short.class == type) {
            return (T)Short.valueOf((short)value);
        }
        if (Integer.TYPE == type || Integer.class == type) {
            return (T)Integer.valueOf((int)value);
        }
        if (Long.TYPE == type || Long.class == type) {
            return (T)Long.valueOf(value);
        }
        if (BigInteger.class == type) {
            if (value < 0L) {
                return (T)BigIntegerCodec.unsignedBigInteger(value);
            }
            return (T)BigInteger.valueOf(value);
        }
        if (type.isAssignableFrom(Number.class)) {
            if (value < 0L) {
                return (T)BigIntegerCodec.unsignedBigInteger(value);
            }
            return (T)Long.valueOf(value);
        }
        String message = "Cannot decode value of type '%s' with last inserted ID %s";
        message = value < 0L ? String.format(message, type, Long.toUnsignedString(value)) : String.format(message, type, value);
        throw new IllegalArgumentException(message);
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        AssertUtils.requireNonNull(value, "value must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        for (Codec<?, ?, ?> codec : this.codecs) {
            if (!codec.canEncode(value)) continue;
            return codec.encode(value, context);
        }
        throw new IllegalArgumentException(String.format("Cannot encode value of type '%s'", value.getClass()));
    }

    @Override
    public ParameterValue encodeNull() {
        return NullParameterValue.INSTANCE;
    }

    private static Type chooseTarget(FieldInformation info, Type target) {
        Class<?> mainType;
        if (Object.class == target && (mainType = info.getJavaType()) != null) {
            return mainType;
        }
        return target;
    }
}

