/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.TypePredicates;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

final class DoubleCodec
extends AbstractPrimitiveCodec<Double> {
    static final DoubleCodec INSTANCE = new DoubleCodec();

    private DoubleCodec() {
        super(Double.TYPE, Double.class);
    }

    @Override
    public Double decode(NormalFieldValue value, FieldInformation info, Class<? super Double> target, boolean binary, ConnectionContext context) {
        ByteBuf buf = value.getBufferSlice();
        if (binary) {
            switch (info.getType()) {
                case 5: {
                    return buf.readDoubleLE();
                }
                case 4: {
                    return buf.readFloatLE();
                }
            }
        }
        return Double.parseDouble(buf.toString(StandardCharsets.US_ASCII));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Double;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return new DoubleValue((Double)value);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        short type = info.getType();
        return 5 == type || 4 == type || info.getSize() < 16L && TypePredicates.isDecimal(type);
    }

    private static final class DoubleValue
    extends AbstractParameterValue {
        private final double value;

        private DoubleValue(double value) {
            this.value = value;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeDouble(this.value));
        }

        @Override
        public short getType() {
            return 5;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DoubleValue)) {
                return false;
            }
            DoubleValue that = (DoubleValue)o;
            return Double.compare(that.value, this.value) == 0;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.value);
            return (int)(temp ^ temp >>> 32);
        }
    }
}

