/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.CodecDateUtils;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.LocalTimeCodec;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import reactor.core.publisher.Mono;

final class DurationCodec
extends AbstractClassedCodec<Duration> {
    static final DurationCodec INSTANCE = new DurationCodec();

    private DurationCodec() {
        super(Duration.class);
    }

    @Override
    public Duration decode(NormalFieldValue value, FieldInformation info, Class<? super Duration> target, boolean binary, ConnectionContext context) {
        if (binary) {
            return DurationCodec.decodeBinary(value.getBufferSlice());
        }
        return DurationCodec.decodeText(value.getBufferSlice());
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Duration;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return new DurationValue((Duration)value);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        return 11 == info.getType();
    }

    private static Duration decodeText(ByteBuf buf) {
        boolean isNegative = LocalTimeCodec.readNegative(buf);
        int hour = CodecDateUtils.readIntInDigits(buf);
        int minute = CodecDateUtils.readIntInDigits(buf);
        int second = CodecDateUtils.readIntInDigits(buf);
        long totalSeconds = TimeUnit.HOURS.toSeconds(hour) + TimeUnit.MINUTES.toSeconds(minute) + (long)second;
        return Duration.ofSeconds(isNegative ? -totalSeconds : totalSeconds);
    }

    private static Duration decodeBinary(ByteBuf buf) {
        int bytes = buf.readableBytes();
        if (bytes < 8) {
            return Duration.ZERO;
        }
        boolean isNegative = buf.readBoolean();
        long day = buf.readUnsignedIntLE();
        byte hour = buf.readByte();
        byte minute = buf.readByte();
        byte second = buf.readByte();
        long totalSeconds = TimeUnit.DAYS.toSeconds(day) + TimeUnit.HOURS.toSeconds(hour) + TimeUnit.MINUTES.toSeconds(minute) + (long)second;
        if (bytes < 12) {
            return Duration.ofSeconds(isNegative ? -totalSeconds : totalSeconds);
        }
        long nanos = TimeUnit.MICROSECONDS.toNanos(buf.readUnsignedIntLE());
        return Duration.ofSeconds(isNegative ? -totalSeconds : totalSeconds, isNegative ? -nanos : nanos);
    }

    private static final class DurationValue
    extends AbstractParameterValue {
        private final Duration value;

        private DurationValue(Duration value) {
            this.value = value;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeDuration(this.value));
        }

        @Override
        public short getType() {
            return 11;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DurationValue)) {
                return false;
            }
            DurationValue that = (DurationValue)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

