/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.TypePredicates;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

final class FloatCodec
extends AbstractPrimitiveCodec<Float> {
    static final FloatCodec INSTANCE = new FloatCodec();

    private FloatCodec() {
        super(Float.TYPE, Float.class);
    }

    @Override
    public Float decode(NormalFieldValue value, FieldInformation info, Class<? super Float> target, boolean binary, ConnectionContext context) {
        ByteBuf buf = value.getBufferSlice();
        if (binary && info.getType() == 4) {
            return Float.valueOf(buf.readFloatLE());
        }
        return Float.valueOf(Float.parseFloat(buf.toString(StandardCharsets.US_ASCII)));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Float;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return new FloatValue(((Float)value).floatValue());
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        short type = info.getType();
        return 4 == type || info.getSize() < 7L && TypePredicates.isDecimal(type);
    }

    private static final class FloatValue
    extends AbstractParameterValue {
        private final float value;

        private FloatValue(float value) {
            this.value = value;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeFloat(this.value));
        }

        @Override
        public short getType() {
            return 4;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FloatValue)) {
                return false;
            }
            FloatValue that = (FloatValue)o;
            return Float.compare(that.value, this.value) == 0;
        }

        public int hashCode() {
            return this.value != 0.0f ? Float.floatToIntBits(this.value) : 0;
        }
    }
}

