/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.ByteCodec;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.ShortCodec;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import reactor.core.publisher.Mono;

final class IntegerCodec
extends AbstractPrimitiveCodec<Integer> {
    static final IntegerCodec INSTANCE = new IntegerCodec();

    private IntegerCodec() {
        super(Integer.TYPE, Integer.class);
    }

    @Override
    public Integer decode(NormalFieldValue value, FieldInformation info, Class<? super Integer> target, boolean binary, ConnectionContext context) {
        ByteBuf buf = value.getBufferSlice();
        if (binary) {
            boolean isUnsigned = (info.getDefinitions() & 0x20) != 0;
            return IntegerCodec.decodeBinary(buf, info.getType(), isUnsigned);
        }
        return IntegerCodec.parse(buf);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Integer;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        int v = (Integer)value;
        if ((byte)v == v) {
            return new ByteCodec.ByteValue((byte)v);
        }
        if ((short)v == v) {
            return new ShortCodec.ShortValue((short)v);
        }
        return new IntValue(v);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        short type = info.getType();
        return IntegerCodec.isLowerInt(type) || 3 == type && (info.getDefinitions() & 0x20) == 0;
    }

    static int parse(ByteBuf buf) {
        int value;
        boolean isNegative;
        byte first = buf.readByte();
        if (first == 45) {
            isNegative = true;
            value = 0;
        } else if (first >= 48 && first <= 57) {
            isNegative = false;
            value = first - 48;
        } else {
            isNegative = false;
            value = 0;
        }
        while (buf.isReadable()) {
            value = value * 10 + (buf.readByte() - 48);
        }
        return isNegative ? -value : value;
    }

    private static boolean isLowerInt(short type) {
        return 1 == type || 13 == type || 2 == type || 9 == type;
    }

    private static int decodeBinary(ByteBuf buf, short type, boolean isUnsigned) {
        switch (type) {
            case 3: 
            case 9: {
                return buf.readIntLE();
            }
            case 2: {
                if (isUnsigned) {
                    return buf.readUnsignedShortLE();
                }
                return buf.readShortLE();
            }
            case 13: {
                return buf.readShortLE();
            }
        }
        if (isUnsigned) {
            return buf.readUnsignedByte();
        }
        return buf.readByte();
    }

    static final class IntValue
    extends AbstractParameterValue {
        private final int value;

        IntValue(int value) {
            this.value = value;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeInt(this.value));
        }

        @Override
        public short getType() {
            return 3;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntValue)) {
                return false;
            }
            IntValue intValue = (IntValue)o;
            return this.value == intValue.value;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

