/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.CodecDateUtils;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import java.time.LocalDate;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

final class LocalDateCodec
extends AbstractClassedCodec<LocalDate> {
    static final LocalDate ROUND = LocalDate.of(1, 1, 1);
    static final LocalDateCodec INSTANCE = new LocalDateCodec();

    private LocalDateCodec() {
        super(LocalDate.class);
    }

    @Override
    public LocalDate decode(NormalFieldValue value, FieldInformation info, Class<? super LocalDate> target, boolean binary, ConnectionContext context) {
        ByteBuf buf = value.getBufferSlice();
        int index = buf.readerIndex();
        int bytes = buf.readableBytes();
        if (binary) {
            LocalDate date = LocalDateCodec.readDateBinary(buf, bytes);
            if (date == null) {
                return CodecDateUtils.handle(context.getZeroDateOption(), true, buf, index, bytes, ROUND);
            }
            return date;
        }
        LocalDate date = LocalDateCodec.readDateText(buf);
        if (date == null) {
            return CodecDateUtils.handle(context.getZeroDateOption(), false, buf, index, bytes, ROUND);
        }
        return date;
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof LocalDate;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return new LocalDateValue((LocalDate)value);
    }

    @Override
    public boolean doCanDecode(FieldInformation info) {
        return 10 == info.getType();
    }

    @Nullable
    static LocalDate readDateText(ByteBuf buf) {
        int year = CodecDateUtils.readIntInDigits(buf);
        int month = CodecDateUtils.readIntInDigits(buf);
        int day = CodecDateUtils.readIntInDigits(buf);
        if (month == 0 || day == 0) {
            return null;
        }
        return LocalDate.of(year, month, day);
    }

    @Nullable
    static LocalDate readDateBinary(ByteBuf buf, int bytes) {
        if (bytes < 4) {
            return null;
        }
        short year = buf.readShortLE();
        byte month = buf.readByte();
        byte day = buf.readByte();
        if (month == 0 || day == 0) {
            return null;
        }
        return LocalDate.of((int)year, month, (int)day);
    }

    private static final class LocalDateValue
    extends AbstractParameterValue {
        private final LocalDate date;

        private LocalDateValue(LocalDate date) {
            this.date = date;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeDate(this.date));
        }

        @Override
        public short getType() {
            return 10;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LocalDateValue)) {
                return false;
            }
            LocalDateValue that = (LocalDateValue)o;
            return this.date.equals(that.date);
        }

        public int hashCode() {
            return this.date.hashCode();
        }
    }
}

