/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.Codec;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.collation.CharCollation;
import dev.miku.r2dbc.mysql.message.FieldValue;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class SetCodec
implements Codec<Set<?>, NormalFieldValue, ParameterizedType> {
    static final SetCodec INSTANCE = new SetCodec();

    private SetCodec() {
    }

    @Override
    public Set<?> decode(NormalFieldValue value, FieldInformation info, ParameterizedType target, boolean binary, ConnectionContext context) {
        ByteBuf buf = value.getBufferSlice();
        if (!buf.isReadable()) {
            return Collections.emptySet();
        }
        Class subClass = (Class)target.getActualTypeArguments()[0];
        Charset charset = CharCollation.fromId(info.getCollationId(), context.getServerVersion()).getCharset();
        int firstComma = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)44);
        if (firstComma < 0) {
            if (subClass.isEnum()) {
                return Collections.singleton(Enum.valueOf(subClass, buf.toString(charset)));
            }
            return Collections.singleton(buf.toString(charset));
        }
        SplitIterable elements = new SplitIterable(buf, charset, firstComma);
        Set<?> result = SetCodec.buildSet(subClass);
        if (subClass.isEnum()) {
            Class enumClass = subClass;
            Set<?> enumSet = result;
            for (String element : elements) {
                enumSet.add(Enum.valueOf(enumClass, element));
            }
        } else {
            for (String element : elements) {
                result.add(element);
            }
        }
        return result;
    }

    @Override
    public boolean canDecode(FieldValue value, FieldInformation info, Type target) {
        if (248 != info.getType() || !(target instanceof ParameterizedType) || !(value instanceof NormalFieldValue)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)target;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments.length != 1) {
            return false;
        }
        Type rawType = parameterizedType.getRawType();
        Type subType = typeArguments[0];
        if (!(rawType instanceof Class) || !(subType instanceof Class)) {
            return false;
        }
        Class rawClass = (Class)rawType;
        Class subClass = (Class)subType;
        return rawClass.isAssignableFrom(Set.class) && (subClass.isEnum() || subClass.isAssignableFrom(String.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Set && SetCodec.isValidSet((Set)value);
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return new SetValue((Set)value, context);
    }

    private static Set<?> buildSet(Class<?> subClass) {
        if (subClass.isEnum()) {
            EnumSet<?> s = EnumSet.noneOf(subClass);
            return s;
        }
        return new LinkedHashSet();
    }

    private static boolean isValidSet(Set<?> value) {
        for (Object element : value) {
            if (element != null && (element instanceof CharSequence || element.getClass().isEnum())) continue;
            return false;
        }
        return true;
    }

    private static final class SetValue
    extends AbstractParameterValue {
        private static final Function<Object, CharSequence> ELEMENT_CONVERT = element -> {
            if (element.getClass().isEnum()) {
                return ((Enum)element).name();
            }
            return element.toString();
        };
        private final Set<?> set;
        private final ConnectionContext context;

        private SetValue(Set<?> set, ConnectionContext context) {
            this.set = set;
            this.context = context;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Flux.fromIterable(this.set).map(ELEMENT_CONVERT).collectList().doOnNext(strings -> writer.writeSet((List<CharSequence>)strings, this.context.getCollation())).then();
        }

        @Override
        public short getType() {
            return 15;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SetValue)) {
                return false;
            }
            SetValue setValue = (SetValue)o;
            return this.set.equals(setValue.set);
        }

        public int hashCode() {
            return this.set.hashCode();
        }
    }

    private static final class SplitIterator
    implements Iterator<String> {
        private final ByteBuf buf;
        private final Charset charset;
        private int lastChar;
        private int currentComma;
        private final int writerIndex;

        SplitIterator(ByteBuf buf, Charset charset, int currentComma) {
            this.buf = buf;
            this.charset = charset;
            this.lastChar = buf.readerIndex();
            this.currentComma = currentComma;
            this.writerIndex = buf.writerIndex();
        }

        @Override
        public boolean hasNext() {
            return this.currentComma <= this.writerIndex && this.currentComma >= this.lastChar;
        }

        @Override
        public String next() {
            int nextStart;
            String result = this.buf.toString(this.lastChar, this.currentComma - this.lastChar, this.charset);
            this.lastChar = nextStart = this.currentComma + 1;
            this.currentComma = this.nextComma(nextStart);
            return result;
        }

        private int nextComma(int nextStart) {
            if (nextStart > this.writerIndex) {
                return nextStart;
            }
            int index = this.buf.indexOf(nextStart, this.writerIndex, (byte)44);
            if (index < 0) {
                return this.writerIndex;
            }
            return index;
        }
    }

    private static final class SplitIterable
    implements Iterable<String> {
        private final ByteBuf buf;
        private final Charset charset;
        private final int firstComma;

        SplitIterable(ByteBuf buf, Charset charset, int firstComma) {
            this.buf = buf;
            this.charset = charset;
            this.firstComma = firstComma < 0 ? buf.writerIndex() : firstComma;
        }

        @Override
        public Iterator<String> iterator() {
            return new SplitIterator(this.buf, this.charset, this.firstComma);
        }
    }
}

