/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.ByteCodec;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.IntegerCodec;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import reactor.core.publisher.Mono;

final class ShortCodec
extends AbstractPrimitiveCodec<Short> {
    static final ShortCodec INSTANCE = new ShortCodec();

    private ShortCodec() {
        super(Short.TYPE, Short.class);
    }

    @Override
    public Short decode(NormalFieldValue value, FieldInformation info, Class<? super Short> target, boolean binary, ConnectionContext context) {
        if (binary) {
            ByteBuf buf = value.getBufferSlice();
            boolean isUnsigned = (info.getDefinitions() & 0x20) != 0;
            switch (info.getType()) {
                case 2: 
                case 13: {
                    return buf.readShortLE();
                }
            }
            if (isUnsigned) {
                return buf.readUnsignedByte();
            }
            return buf.readByte();
        }
        return (short)IntegerCodec.parse(value.getBufferSlice());
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Short;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        short v = (Short)value;
        if ((byte)v == v) {
            return new ByteCodec.ByteValue((byte)v);
        }
        return new ShortValue(v);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        short type = info.getType();
        if (1 == type || 13 == type) {
            return true;
        }
        return 2 == type && (info.getDefinitions() & 0x20) == 0;
    }

    static final class ShortValue
    extends AbstractParameterValue {
        private final short value;

        ShortValue(short value) {
            this.value = value;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeShort(this.value));
        }

        @Override
        public short getType() {
            return 2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ShortValue)) {
                return false;
            }
            ShortValue that = (ShortValue)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

