/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.collation.CharCollation;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import dev.miku.r2dbc.mysql.util.InternalArrays;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.List;
import reactor.core.publisher.Mono;

final class StringArrayCodec
extends AbstractClassedCodec<String[]> {
    static final StringArrayCodec INSTANCE = new StringArrayCodec();

    private StringArrayCodec() {
        super(String[].class);
    }

    @Override
    public String[] decode(NormalFieldValue value, FieldInformation info, Class<? super String[]> target, boolean binary, ConnectionContext context) {
        ByteBuf buf = value.getBufferSlice();
        if (!buf.isReadable()) {
            return InternalArrays.EMPTY_STRINGS;
        }
        int firstComma = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)44);
        Charset charset = CharCollation.fromId(info.getCollationId(), context.getServerVersion()).getCharset();
        if (firstComma < 0) {
            return new String[]{buf.toString(charset)};
        }
        return buf.toString(charset).split(",");
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof CharSequence[];
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return new StringArrayValue(InternalArrays.toReadOnlyList((CharSequence[])value), context);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        return 248 == info.getType();
    }

    private static final class StringArrayValue
    extends AbstractParameterValue {
        private final List<CharSequence> value;
        private final ConnectionContext context;

        private StringArrayValue(List<CharSequence> value, ConnectionContext context) {
            this.value = value;
            this.context = context;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeSet(this.value, this.context.getCollation()));
        }

        @Override
        public short getType() {
            return 15;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StringArrayValue)) {
                return false;
            }
            StringArrayValue that = (StringArrayValue)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

