/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.collation;

import dev.miku.r2dbc.mysql.collation.BinaryTarget;
import dev.miku.r2dbc.mysql.collation.CachedCharCollation;
import dev.miku.r2dbc.mysql.collation.CharCollation;
import dev.miku.r2dbc.mysql.collation.CharsetTarget;
import dev.miku.r2dbc.mysql.collation.CharsetTargets;
import dev.miku.r2dbc.mysql.collation.LazyInitCharCollation;
import dev.miku.r2dbc.mysql.util.ServerVersion;

final class CharCollations {
    static final CharCollation BINARY;
    static final CharCollation UTF8MB4_GENERAL_CI;
    private static final CharCollation LATIN1_GENERAL_CI;
    private static final CharCollation UTF8MB4_0900_AI_CI;
    private static final CharCollation ASCII_GENERAL_CI;
    private static final CharCollation[] COSMOS;
    private static final CharCollation[] EXTRA;
    private static final ServerVersion UTF8MB4_0900_VER;

    private CharCollations() {
    }

    static CharCollation fromId(int id, ServerVersion version) {
        if (id < 0 || id >= COSMOS.length) {
            for (CharCollation collation : EXTRA) {
                if (collation.getId() != id) continue;
                return collation;
            }
            return CharCollations.defaultServerCollation(version);
        }
        CharCollation collation = COSMOS[id];
        if (collation == null) {
            return CharCollations.defaultServerCollation(version);
        }
        return collation;
    }

    private static CharCollation defaultServerCollation(ServerVersion version) {
        if (version.isGreaterThanOrEqualTo(UTF8MB4_0900_VER)) {
            return UTF8MB4_0900_AI_CI;
        }
        return UTF8MB4_GENERAL_CI;
    }

    private static int cosmosSize(CharCollation[] universe) {
        int result = 0;
        for (CharCollation collation : universe) {
            int id = collation.getId();
            if (id <= result) continue;
            result = id;
        }
        if (result > 0) {
            return result + 1;
        }
        return 0;
    }

    private static CharCollation createCollation(int id, String name, CharsetTarget target) {
        if (target.isCached()) {
            return new CachedCharCollation(id, name, target);
        }
        return new LazyInitCharCollation(id, name, target);
    }

    private static CharCollation[] universeBigBang() {
        return new CharCollation[]{CharCollations.createCollation(1, "big5_chinese_ci", CharsetTargets.BIG5), CharCollations.createCollation(2, "latin2_czech_cs", CharsetTargets.LATIN2), CharCollations.createCollation(3, "dec8_swedish_ci", CharsetTargets.DEC8), CharCollations.createCollation(4, "cp850_general_ci", CharsetTargets.CP850), CharCollations.createCollation(5, "latin1_german1_ci", CharsetTargets.LATIN1), CharCollations.createCollation(6, "hp8_english_ci", CharsetTargets.HP8), CharCollations.createCollation(7, "koi8r_general_ci", CharsetTargets.KOI8_R), CharCollations.createCollation(8, "latin1_swedish_ci", CharsetTargets.LATIN1), CharCollations.createCollation(9, "latin2_general_ci", CharsetTargets.LATIN2), CharCollations.createCollation(10, "swe7_swedish_ci", CharsetTargets.SWE7), ASCII_GENERAL_CI, CharCollations.createCollation(12, "ujis_japanese_ci", CharsetTargets.EUC_JIS), CharCollations.createCollation(13, "sjis_japanese_ci", CharsetTargets.SHIFT_JIS), CharCollations.createCollation(14, "cp1251_bulgarian_ci", CharsetTargets.CP1251), CharCollations.createCollation(15, "latin1_danish_ci", CharsetTargets.LATIN1), CharCollations.createCollation(16, "hebrew_general_ci", CharsetTargets.HEBREW), CharCollations.createCollation(18, "tis620_thai_ci", CharsetTargets.TIS620), CharCollations.createCollation(19, "euckr_korean_ci", CharsetTargets.EUC_KR), CharCollations.createCollation(20, "latin7_estonian_cs", CharsetTargets.LATIN7), CharCollations.createCollation(21, "latin2_hungarian_ci", CharsetTargets.LATIN2), CharCollations.createCollation(22, "koi8u_general_ci", CharsetTargets.KOI8_U), CharCollations.createCollation(23, "cp1251_ukrainian_ci", CharsetTargets.CP1251), CharCollations.createCollation(24, "gb2312_chinese_ci", CharsetTargets.GB2312), CharCollations.createCollation(25, "greek_general_ci", CharsetTargets.GREEK), CharCollations.createCollation(26, "cp1250_general_ci", CharsetTargets.CP1250), CharCollations.createCollation(27, "latin2_croatian_ci", CharsetTargets.LATIN2), CharCollations.createCollation(28, "gbk_chinese_ci", CharsetTargets.GBK), CharCollations.createCollation(29, "cp1257_lithuanian_ci", CharsetTargets.CP1257), CharCollations.createCollation(30, "latin5_turkish_ci", CharsetTargets.LATIN5), CharCollations.createCollation(31, "latin1_german2_ci", CharsetTargets.LATIN1), CharCollations.createCollation(32, "armscii8_general_ci", CharsetTargets.ARMSCII8), CharCollations.createCollation(33, "utf8_general_ci", CharsetTargets.UTF8), CharCollations.createCollation(34, "cp1250_czech_cs", CharsetTargets.CP1250), CharCollations.createCollation(35, "ucs2_general_ci", CharsetTargets.UCS2), CharCollations.createCollation(36, "cp866_general_ci", CharsetTargets.CP866), CharCollations.createCollation(37, "keybcs2_general_ci", CharsetTargets.KEYBCS2), CharCollations.createCollation(38, "macce_general_ci", CharsetTargets.MAC_CE), CharCollations.createCollation(39, "macroman_general_ci", CharsetTargets.MAC_ROMAN), CharCollations.createCollation(40, "cp852_general_ci", CharsetTargets.CP852), CharCollations.createCollation(41, "latin7_general_ci", CharsetTargets.LATIN7), CharCollations.createCollation(42, "latin7_general_cs", CharsetTargets.LATIN7), CharCollations.createCollation(43, "macce_bin", CharsetTargets.MAC_CE), CharCollations.createCollation(44, "cp1250_croatian_ci", CharsetTargets.CP1250), UTF8MB4_GENERAL_CI, CharCollations.createCollation(46, "utf8mb4_bin", CharsetTargets.UTF8MB4), CharCollations.createCollation(47, "latin1_bin", CharsetTargets.LATIN1), LATIN1_GENERAL_CI, CharCollations.createCollation(49, "latin1_general_cs", CharsetTargets.LATIN1), CharCollations.createCollation(50, "cp1251_bin", CharsetTargets.CP1251), CharCollations.createCollation(51, "cp1251_general_ci", CharsetTargets.CP1251), CharCollations.createCollation(52, "cp1251_general_cs", CharsetTargets.CP1251), CharCollations.createCollation(53, "macroman_bin", CharsetTargets.MAC_ROMAN), CharCollations.createCollation(54, "utf16_general_ci", CharsetTargets.UTF16), CharCollations.createCollation(55, "utf16_bin", CharsetTargets.UTF16), CharCollations.createCollation(56, "utf16le_general_ci", CharsetTargets.UTF16LE), CharCollations.createCollation(57, "cp1256_general_ci", CharsetTargets.CP1256), CharCollations.createCollation(58, "cp1257_bin", CharsetTargets.CP1257), CharCollations.createCollation(59, "cp1257_general_ci", CharsetTargets.CP1257), CharCollations.createCollation(60, "utf32_general_ci", CharsetTargets.UTF32), CharCollations.createCollation(61, "utf32_bin", CharsetTargets.UTF32), CharCollations.createCollation(62, "utf16le_bin", CharsetTargets.UTF16LE), BINARY, CharCollations.createCollation(64, "armscii8_bin", CharsetTargets.ARMSCII8), CharCollations.createCollation(65, "ascii_bin", CharsetTargets.ASCII), CharCollations.createCollation(66, "cp1250_bin", CharsetTargets.CP1250), CharCollations.createCollation(67, "cp1256_bin", CharsetTargets.CP1256), CharCollations.createCollation(68, "cp866_bin", CharsetTargets.CP866), CharCollations.createCollation(69, "dec8_bin", CharsetTargets.DEC8), CharCollations.createCollation(70, "greek_bin", CharsetTargets.GREEK), CharCollations.createCollation(71, "hebrew_bin", CharsetTargets.HEBREW), CharCollations.createCollation(72, "hp8_bin", CharsetTargets.HP8), CharCollations.createCollation(73, "keybcs2_bin", CharsetTargets.KEYBCS2), CharCollations.createCollation(74, "koi8r_bin", CharsetTargets.KOI8_R), CharCollations.createCollation(75, "koi8u_bin", CharsetTargets.KOI8_U), CharCollations.createCollation(76, "utf8_tolower_ci", CharsetTargets.UTF8), CharCollations.createCollation(77, "latin2_bin", CharsetTargets.LATIN2), CharCollations.createCollation(78, "latin5_bin", CharsetTargets.LATIN5), CharCollations.createCollation(79, "latin7_bin", CharsetTargets.LATIN7), CharCollations.createCollation(80, "cp850_bin", CharsetTargets.CP850), CharCollations.createCollation(81, "cp852_bin", CharsetTargets.CP852), CharCollations.createCollation(82, "swe7_bin", CharsetTargets.SWE7), CharCollations.createCollation(83, "utf8_bin", CharsetTargets.UTF8), CharCollations.createCollation(84, "big5_bin", CharsetTargets.BIG5), CharCollations.createCollation(85, "euckr_bin", CharsetTargets.EUC_KR), CharCollations.createCollation(86, "gb2312_bin", CharsetTargets.GB2312), CharCollations.createCollation(87, "gbk_bin", CharsetTargets.GBK), CharCollations.createCollation(88, "sjis_bin", CharsetTargets.SHIFT_JIS), CharCollations.createCollation(89, "tis620_bin", CharsetTargets.TIS620), CharCollations.createCollation(90, "ucs2_bin", CharsetTargets.UCS2), CharCollations.createCollation(91, "ujis_bin", CharsetTargets.EUC_JIS), CharCollations.createCollation(92, "geostd8_general_ci", CharsetTargets.GEOSTD8), CharCollations.createCollation(93, "geostd8_bin", CharsetTargets.GEOSTD8), CharCollations.createCollation(94, "latin1_spanish_ci", CharsetTargets.LATIN1), CharCollations.createCollation(95, "cp932_japanese_ci", CharsetTargets.CP932), CharCollations.createCollation(96, "cp932_bin", CharsetTargets.CP932), CharCollations.createCollation(97, "eucjpms_japanese_ci", CharsetTargets.EUC_JPMS), CharCollations.createCollation(98, "eucjpms_bin", CharsetTargets.EUC_JPMS), CharCollations.createCollation(99, "cp1250_polish_ci", CharsetTargets.CP1250), CharCollations.createCollation(101, "utf16_unicode_ci", CharsetTargets.UTF16), CharCollations.createCollation(102, "utf16_icelandic_ci", CharsetTargets.UTF16), CharCollations.createCollation(103, "utf16_latvian_ci", CharsetTargets.UTF16), CharCollations.createCollation(104, "utf16_romanian_ci", CharsetTargets.UTF16), CharCollations.createCollation(105, "utf16_slovenian_ci", CharsetTargets.UTF16), CharCollations.createCollation(106, "utf16_polish_ci", CharsetTargets.UTF16), CharCollations.createCollation(107, "utf16_estonian_ci", CharsetTargets.UTF16), CharCollations.createCollation(108, "utf16_spanish_ci", CharsetTargets.UTF16), CharCollations.createCollation(109, "utf16_swedish_ci", CharsetTargets.UTF16), CharCollations.createCollation(110, "utf16_turkish_ci", CharsetTargets.UTF16), CharCollations.createCollation(111, "utf16_czech_ci", CharsetTargets.UTF16), CharCollations.createCollation(112, "utf16_danish_ci", CharsetTargets.UTF16), CharCollations.createCollation(113, "utf16_lithuanian_ci", CharsetTargets.UTF16), CharCollations.createCollation(114, "utf16_slovak_ci", CharsetTargets.UTF16), CharCollations.createCollation(115, "utf16_spanish2_ci", CharsetTargets.UTF16), CharCollations.createCollation(116, "utf16_roman_ci", CharsetTargets.UTF16), CharCollations.createCollation(117, "utf16_persian_ci", CharsetTargets.UTF16), CharCollations.createCollation(118, "utf16_esperanto_ci", CharsetTargets.UTF16), CharCollations.createCollation(119, "utf16_hungarian_ci", CharsetTargets.UTF16), CharCollations.createCollation(120, "utf16_sinhala_ci", CharsetTargets.UTF16), CharCollations.createCollation(121, "utf16_german2_ci", CharsetTargets.UTF16), CharCollations.createCollation(122, "utf16_croatian_ci", CharsetTargets.UTF16), CharCollations.createCollation(123, "utf16_unicode_520_ci", CharsetTargets.UTF16), CharCollations.createCollation(124, "utf16_vietnamese_ci", CharsetTargets.UTF16), CharCollations.createCollation(128, "ucs2_unicode_ci", CharsetTargets.UCS2), CharCollations.createCollation(129, "ucs2_icelandic_ci", CharsetTargets.UCS2), CharCollations.createCollation(130, "ucs2_latvian_ci", CharsetTargets.UCS2), CharCollations.createCollation(131, "ucs2_romanian_ci", CharsetTargets.UCS2), CharCollations.createCollation(132, "ucs2_slovenian_ci", CharsetTargets.UCS2), CharCollations.createCollation(133, "ucs2_polish_ci", CharsetTargets.UCS2), CharCollations.createCollation(134, "ucs2_estonian_ci", CharsetTargets.UCS2), CharCollations.createCollation(135, "ucs2_spanish_ci", CharsetTargets.UCS2), CharCollations.createCollation(136, "ucs2_swedish_ci", CharsetTargets.UCS2), CharCollations.createCollation(137, "ucs2_turkish_ci", CharsetTargets.UCS2), CharCollations.createCollation(138, "ucs2_czech_ci", CharsetTargets.UCS2), CharCollations.createCollation(139, "ucs2_danish_ci", CharsetTargets.UCS2), CharCollations.createCollation(140, "ucs2_lithuanian_ci", CharsetTargets.UCS2), CharCollations.createCollation(141, "ucs2_slovak_ci", CharsetTargets.UCS2), CharCollations.createCollation(142, "ucs2_spanish2_ci", CharsetTargets.UCS2), CharCollations.createCollation(143, "ucs2_roman_ci", CharsetTargets.UCS2), CharCollations.createCollation(144, "ucs2_persian_ci", CharsetTargets.UCS2), CharCollations.createCollation(145, "ucs2_esperanto_ci", CharsetTargets.UCS2), CharCollations.createCollation(146, "ucs2_hungarian_ci", CharsetTargets.UCS2), CharCollations.createCollation(147, "ucs2_sinhala_ci", CharsetTargets.UCS2), CharCollations.createCollation(148, "ucs2_german2_ci", CharsetTargets.UCS2), CharCollations.createCollation(149, "ucs2_croatian_ci", CharsetTargets.UCS2), CharCollations.createCollation(150, "ucs2_unicode_520_ci", CharsetTargets.UCS2), CharCollations.createCollation(151, "ucs2_vietnamese_ci", CharsetTargets.UCS2), CharCollations.createCollation(159, "ucs2_general_mysql500_ci", CharsetTargets.UCS2), CharCollations.createCollation(160, "utf32_unicode_ci", CharsetTargets.UTF32), CharCollations.createCollation(161, "utf32_icelandic_ci", CharsetTargets.UTF32), CharCollations.createCollation(162, "utf32_latvian_ci", CharsetTargets.UTF32), CharCollations.createCollation(163, "utf32_romanian_ci", CharsetTargets.UTF32), CharCollations.createCollation(164, "utf32_slovenian_ci", CharsetTargets.UTF32), CharCollations.createCollation(165, "utf32_polish_ci", CharsetTargets.UTF32), CharCollations.createCollation(166, "utf32_estonian_ci", CharsetTargets.UTF32), CharCollations.createCollation(167, "utf32_spanish_ci", CharsetTargets.UTF32), CharCollations.createCollation(168, "utf32_swedish_ci", CharsetTargets.UTF32), CharCollations.createCollation(169, "utf32_turkish_ci", CharsetTargets.UTF32), CharCollations.createCollation(170, "utf32_czech_ci", CharsetTargets.UTF32), CharCollations.createCollation(171, "utf32_danish_ci", CharsetTargets.UTF32), CharCollations.createCollation(172, "utf32_lithuanian_ci", CharsetTargets.UTF32), CharCollations.createCollation(173, "utf32_slovak_ci", CharsetTargets.UTF32), CharCollations.createCollation(174, "utf32_spanish2_ci", CharsetTargets.UTF32), CharCollations.createCollation(175, "utf32_roman_ci", CharsetTargets.UTF32), CharCollations.createCollation(176, "utf32_persian_ci", CharsetTargets.UTF32), CharCollations.createCollation(177, "utf32_esperanto_ci", CharsetTargets.UTF32), CharCollations.createCollation(178, "utf32_hungarian_ci", CharsetTargets.UTF32), CharCollations.createCollation(179, "utf32_sinhala_ci", CharsetTargets.UTF32), CharCollations.createCollation(180, "utf32_german2_ci", CharsetTargets.UTF32), CharCollations.createCollation(181, "utf32_croatian_ci", CharsetTargets.UTF32), CharCollations.createCollation(182, "utf32_unicode_520_ci", CharsetTargets.UTF32), CharCollations.createCollation(183, "utf32_vietnamese_ci", CharsetTargets.UTF32), CharCollations.createCollation(192, "utf8_unicode_ci", CharsetTargets.UTF8), CharCollations.createCollation(193, "utf8_icelandic_ci", CharsetTargets.UTF8), CharCollations.createCollation(194, "utf8_latvian_ci", CharsetTargets.UTF8), CharCollations.createCollation(195, "utf8_romanian_ci", CharsetTargets.UTF8), CharCollations.createCollation(196, "utf8_slovenian_ci", CharsetTargets.UTF8), CharCollations.createCollation(197, "utf8_polish_ci", CharsetTargets.UTF8), CharCollations.createCollation(198, "utf8_estonian_ci", CharsetTargets.UTF8), CharCollations.createCollation(199, "utf8_spanish_ci", CharsetTargets.UTF8), CharCollations.createCollation(200, "utf8_swedish_ci", CharsetTargets.UTF8), CharCollations.createCollation(201, "utf8_turkish_ci", CharsetTargets.UTF8), CharCollations.createCollation(202, "utf8_czech_ci", CharsetTargets.UTF8), CharCollations.createCollation(203, "utf8_danish_ci", CharsetTargets.UTF8), CharCollations.createCollation(204, "utf8_lithuanian_ci", CharsetTargets.UTF8), CharCollations.createCollation(205, "utf8_slovak_ci", CharsetTargets.UTF8), CharCollations.createCollation(206, "utf8_spanish2_ci", CharsetTargets.UTF8), CharCollations.createCollation(207, "utf8_roman_ci", CharsetTargets.UTF8), CharCollations.createCollation(208, "utf8_persian_ci", CharsetTargets.UTF8), CharCollations.createCollation(209, "utf8_esperanto_ci", CharsetTargets.UTF8), CharCollations.createCollation(210, "utf8_hungarian_ci", CharsetTargets.UTF8), CharCollations.createCollation(211, "utf8_sinhala_ci", CharsetTargets.UTF8), CharCollations.createCollation(212, "utf8_german2_ci", CharsetTargets.UTF8), CharCollations.createCollation(213, "utf8_croatian_ci", CharsetTargets.UTF8), CharCollations.createCollation(214, "utf8_unicode_520_ci", CharsetTargets.UTF8), CharCollations.createCollation(215, "utf8_vietnamese_ci", CharsetTargets.UTF8), CharCollations.createCollation(223, "utf8_general_mysql500_ci", CharsetTargets.UTF8), CharCollations.createCollation(224, "utf8mb4_unicode_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(225, "utf8mb4_icelandic_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(226, "utf8mb4_latvian_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(227, "utf8mb4_romanian_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(228, "utf8mb4_slovenian_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(229, "utf8mb4_polish_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(230, "utf8mb4_estonian_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(231, "utf8mb4_spanish_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(232, "utf8mb4_swedish_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(233, "utf8mb4_turkish_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(234, "utf8mb4_czech_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(235, "utf8mb4_danish_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(236, "utf8mb4_lithuanian_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(237, "utf8mb4_slovak_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(238, "utf8mb4_spanish2_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(239, "utf8mb4_roman_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(240, "utf8mb4_persian_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(241, "utf8mb4_esperanto_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(242, "utf8mb4_hungarian_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(243, "utf8mb4_sinhala_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(244, "utf8mb4_german2_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(245, "utf8mb4_croatian_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(246, "utf8mb4_unicode_520_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(247, "utf8mb4_vietnamese_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(248, "gb18030_chinese_ci", CharsetTargets.GB18030), CharCollations.createCollation(249, "gb18030_bin", CharsetTargets.GB18030), CharCollations.createCollation(250, "gb18030_unicode_520_ci", CharsetTargets.GB18030), UTF8MB4_0900_AI_CI, CharCollations.createCollation(256, "utf8mb4_de_pb_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(257, "utf8mb4_is_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(258, "utf8mb4_lv_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(259, "utf8mb4_ro_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(260, "utf8mb4_sl_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(261, "utf8mb4_pl_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(262, "utf8mb4_et_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(263, "utf8mb4_es_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(264, "utf8mb4_sv_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(265, "utf8mb4_tr_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(266, "utf8mb4_cs_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(267, "utf8mb4_da_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(268, "utf8mb4_lt_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(269, "utf8mb4_sk_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(270, "utf8mb4_es_trad_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(271, "utf8mb4_la_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(273, "utf8mb4_eo_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(274, "utf8mb4_hu_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(275, "utf8mb4_hr_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(277, "utf8mb4_vi_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(278, "utf8mb4_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(279, "utf8mb4_de_pb_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(280, "utf8mb4_is_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(281, "utf8mb4_lv_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(282, "utf8mb4_ro_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(283, "utf8mb4_sl_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(284, "utf8mb4_pl_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(285, "utf8mb4_et_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(286, "utf8mb4_es_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(287, "utf8mb4_sv_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(288, "utf8mb4_tr_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(289, "utf8mb4_cs_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(290, "utf8mb4_da_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(291, "utf8mb4_lt_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(292, "utf8mb4_sk_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(293, "utf8mb4_es_trad_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(294, "utf8mb4_la_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(296, "utf8mb4_eo_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(297, "utf8mb4_hu_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(298, "utf8mb4_hr_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(300, "utf8mb4_vi_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(303, "utf8mb4_ja_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(304, "utf8mb4_ja_0900_as_cs_ks", CharsetTargets.UTF8MB4), CharCollations.createCollation(305, "utf8mb4_0900_as_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(306, "utf8mb4_ru_0900_ai_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(307, "utf8mb4_ru_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(308, "utf8mb4_zh_0900_as_cs", CharsetTargets.UTF8MB4), CharCollations.createCollation(326, "utf8mb4_test_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(327, "utf16_test_ci", CharsetTargets.UTF16), CharCollations.createCollation(328, "utf8mb4_test_400_ci", CharsetTargets.UTF8MB4), CharCollations.createCollation(336, "utf8_bengali_standard_ci", CharsetTargets.UTF8), CharCollations.createCollation(337, "utf8_bengali_traditional_ci", CharsetTargets.UTF8), CharCollations.createCollation(352, "utf8_phone_ci", CharsetTargets.UTF8), CharCollations.createCollation(353, "utf8_test_ci", CharsetTargets.UTF8), CharCollations.createCollation(354, "utf8_5624_1", CharsetTargets.UTF8), CharCollations.createCollation(355, "utf8_5624_2", CharsetTargets.UTF8), CharCollations.createCollation(356, "utf8_5624_3", CharsetTargets.UTF8), CharCollations.createCollation(357, "utf8_5624_4", CharsetTargets.UTF8), CharCollations.createCollation(358, "ucs2_test_ci", CharsetTargets.UCS2), CharCollations.createCollation(359, "ucs2_vn_ci", CharsetTargets.UCS2), CharCollations.createCollation(360, "ucs2_5624_1", CharsetTargets.UCS2), CharCollations.createCollation(368, "utf8_5624_5", CharsetTargets.UTF8)};
    }

    private static CharCollation[] universeExtra() {
        return new CharCollation[]{CharCollations.createCollation(391, "utf32_test_ci", CharsetTargets.UTF32), CharCollations.createCollation(2047, "utf8_maxuserid_ci", CharsetTargets.UTF8)};
    }

    static {
        UTF8MB4_0900_VER = ServerVersion.create(8, 0, 1);
        ASCII_GENERAL_CI = CharCollations.createCollation(11, "ascii_general_ci", CharsetTargets.ASCII);
        UTF8MB4_GENERAL_CI = CharCollations.createCollation(45, "utf8mb4_general_ci", CharsetTargets.UTF8MB4);
        LATIN1_GENERAL_CI = CharCollations.createCollation(48, "latin1_general_ci", CharsetTargets.LATIN1);
        BINARY = CharCollations.createCollation(63, "binary", BinaryTarget.INSTANCE);
        UTF8MB4_0900_AI_CI = CharCollations.createCollation(255, "utf8mb4_0900_ai_ci", CharsetTargets.UTF8MB4);
        CharCollation[] universe = CharCollations.universeBigBang();
        COSMOS = new CharCollation[CharCollations.cosmosSize(universe)];
        EXTRA = CharCollations.universeExtra();
        CharCollation[] charCollationArray = universe;
        int n = charCollationArray.length;
        for (int i = 0; i < n; ++i) {
            CharCollation collation;
            CharCollations.COSMOS[collation.getId()] = collation = charCollationArray[i];
        }
    }
}

