/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.collation;

import dev.miku.r2dbc.mysql.collation.AbstractCharsetTarget;
import dev.miku.r2dbc.mysql.collation.CharsetTarget;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Objects;
import reactor.util.annotation.Nullable;

final class MixCharsetTarget
extends AbstractCharsetTarget {
    @Nullable
    private final Charset fallbackCharset;
    private final CharsetTarget[] targets;

    MixCharsetTarget(int byteSize, CharsetTarget ... targets) {
        this(byteSize, (Charset)null, targets);
    }

    MixCharsetTarget(int byteSize, @Nullable Charset fallbackCharset, CharsetTarget ... targets) {
        super(MixCharsetTarget.maxByteSize(AssertUtils.requireNonNull(targets, "targets must not be null"), byteSize));
        this.fallbackCharset = fallbackCharset;
        this.targets = targets;
    }

    @Override
    public Charset getCharset() {
        if (this.fallbackCharset == null) {
            return this.getCharsetFallible();
        }
        return this.getCharsetNonFail(this.fallbackCharset);
    }

    @Override
    public boolean isCached() {
        return false;
    }

    private Charset getCharsetFallible() {
        IllegalArgumentException err = null;
        for (CharsetTarget target : this.targets) {
            try {
                return target.getCharset();
            }
            catch (IllegalArgumentException e) {
                if (err == null) {
                    err = e;
                    continue;
                }
                e.addSuppressed(err);
                err = e;
            }
        }
        if (err == null) {
            throw new UnsupportedCharsetException("Charset target not found in MixCharsetTarget");
        }
        throw err;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MixCharsetTarget)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MixCharsetTarget that = (MixCharsetTarget)o;
        if (!Objects.equals(this.fallbackCharset, that.fallbackCharset)) {
            return false;
        }
        return Arrays.equals(this.targets, that.targets);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fallbackCharset != null ? this.fallbackCharset.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.targets);
        return result;
    }

    public String toString() {
        return String.format("MixCharsetTarget{fallbackCharset=%s, targets=%s, byteSize=%d}", this.fallbackCharset, Arrays.toString(this.targets), this.byteSize);
    }

    private Charset getCharsetNonFail(Charset fallback) {
        for (CharsetTarget target : this.targets) {
            try {
                return target.getCharset();
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return fallback;
    }

    private static int maxByteSize(CharsetTarget[] targets, int defaultByteSize) {
        int result = defaultByteSize;
        for (CharsetTarget target : targets) {
            int byteSize = target.getByteSize();
            if (byteSize <= result) continue;
            result = byteSize;
        }
        return result;
    }
}

