/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.client;

import dev.miku.r2dbc.mysql.message.client.ClientMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import reactor.core.publisher.Mono;

abstract class EnvelopeClientMessage
implements ClientMessage {
    private static final int INITIAL_CAPACITY = 256;

    EnvelopeClientMessage() {
    }

    protected abstract void writeTo(ByteBuf var1, ConnectionContext var2);

    public Mono<ByteBuf> encode(ByteBufAllocator allocator, ConnectionContext context) {
        AssertUtils.requireNonNull(allocator, "allocator must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf buf = allocator.buffer(256, 0xFFFFFF);
            try {
                this.writeTo(buf, context);
                return buf;
            }
            catch (Throwable e) {
                buf.release();
                throw e;
            }
        });
    }
}

