/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.client;

import dev.miku.r2dbc.mysql.message.client.FixedSizeClientMessage;
import dev.miku.r2dbc.mysql.message.client.SslRequest;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;

final class SslRequest320
extends FixedSizeClientMessage
implements SslRequest {
    private static final int SIZE = 5;
    private final int capabilities;

    SslRequest320(int capabilities) {
        AssertUtils.require((capabilities & 0x200) == 0, "protocol 4.1 capability should never be set");
        this.capabilities = capabilities;
    }

    @Override
    public int getCapabilities() {
        return this.capabilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SslRequest320)) {
            return false;
        }
        SslRequest320 that = (SslRequest320)o;
        return this.capabilities == that.capabilities;
    }

    public int hashCode() {
        return this.capabilities;
    }

    public String toString() {
        return String.format("SslRequest320{capabilities=%x}", this.capabilities);
    }

    @Override
    protected int size() {
        return 5;
    }

    @Override
    protected void writeTo(ByteBuf buf) {
        buf.writeShortLE(this.capabilities & 0xFFFF).writeMediumLE(0xFFFFFF);
    }
}

