/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.message.FieldValue;
import dev.miku.r2dbc.mysql.message.server.ByteBufJoiner;
import dev.miku.r2dbc.mysql.message.server.LargeFieldReader;
import dev.miku.r2dbc.mysql.message.server.NormalFieldReader;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.List;

interface FieldReader
extends ReferenceCounted {
    public short getUnsignedByte();

    public void skipOneByte();

    public byte[] readSizeFixedBytes(int var1);

    public FieldValue readSizeFixedField(int var1);

    public FieldValue readVarIntSizedField();

    public static FieldReader of(ByteBufJoiner joiner, List<ByteBuf> buffers) {
        AssertUtils.requireNonNull(joiner, "joiner must not be null");
        AssertUtils.requireNonNull(buffers, "buffers must not be null");
        int size = buffers.size();
        long totalSize = 0L;
        try {
            for (int i = 0; i < size && (totalSize += (long)buffers.get(i).readableBytes()) <= Integer.MAX_VALUE; ++i) {
            }
        }
        catch (Throwable e) {
            for (int i = 0; i < size; ++i) {
                ReferenceCountUtil.safeRelease((Object)buffers.get(i));
            }
            buffers.clear();
            throw e;
        }
        if (totalSize <= Integer.MAX_VALUE) {
            ByteBuf joined = joiner.join(buffers);
            try {
                NormalFieldReader i = new NormalFieldReader(joined);
                return i;
            }
            catch (Throwable e) {
                joined.release();
                throw e;
            }
            finally {
                buffers.clear();
            }
        }
        try {
            LargeFieldReader joined = new LargeFieldReader(buffers.toArray(new ByteBuf[size]));
            return joined;
        }
        catch (Throwable e) {
            for (int i = 0; i < size; ++i) {
                ReferenceCountUtil.safeRelease((Object)buffers.get(i));
            }
            throw e;
        }
        finally {
            buffers.clear();
        }
    }
}

