/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.message.header.SequenceIdProvider;
import dev.miku.r2dbc.mysql.message.server.AuthChangeMessage;
import dev.miku.r2dbc.mysql.message.server.AuthMoreDataMessage;
import dev.miku.r2dbc.mysql.message.server.ByteBufJoiner;
import dev.miku.r2dbc.mysql.message.server.ColumnCountMessage;
import dev.miku.r2dbc.mysql.message.server.CommandDecodeContext;
import dev.miku.r2dbc.mysql.message.server.ConnectionDecodeContext;
import dev.miku.r2dbc.mysql.message.server.DecodeContext;
import dev.miku.r2dbc.mysql.message.server.DefinitionMetadataMessage;
import dev.miku.r2dbc.mysql.message.server.EofMessage;
import dev.miku.r2dbc.mysql.message.server.ErrorMessage;
import dev.miku.r2dbc.mysql.message.server.FetchDecodeContext;
import dev.miku.r2dbc.mysql.message.server.FieldReader;
import dev.miku.r2dbc.mysql.message.server.HandshakeRequest;
import dev.miku.r2dbc.mysql.message.server.MetadataDecodeContext;
import dev.miku.r2dbc.mysql.message.server.OkMessage;
import dev.miku.r2dbc.mysql.message.server.PrepareQueryDecodeContext;
import dev.miku.r2dbc.mysql.message.server.PreparedMetadataDecodeContext;
import dev.miku.r2dbc.mysql.message.server.PreparedOkMessage;
import dev.miku.r2dbc.mysql.message.server.ResultDecodeContext;
import dev.miku.r2dbc.mysql.message.server.RowMessage;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.message.server.ServerStatusMessage;
import dev.miku.r2dbc.mysql.message.server.SyntheticMetadataMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.CodecUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import java.util.ArrayList;
import java.util.List;
import reactor.util.annotation.Nullable;

public final class ServerMessageDecoder {
    private static final ByteBufJoiner JOINER = ByteBufJoiner.wrapped();
    private final List<ByteBuf> parts = new ArrayList<ByteBuf>();

    @Nullable
    public ServerMessage decode(ByteBuf envelope, ConnectionContext context, DecodeContext decodeContext, @Nullable SequenceIdProvider.Linkable idProvider) {
        AssertUtils.requireNonNull(envelope, "envelope must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        AssertUtils.requireNonNull(decodeContext, "decodeContext must not be null");
        if (this.readNotFinish(envelope, idProvider)) {
            return null;
        }
        return ServerMessageDecoder.decodeMessage(this.parts, context, decodeContext);
    }

    public void dispose() {
        try {
            for (ByteBuf part : this.parts) {
                ReferenceCountUtil.safeRelease((Object)part);
            }
        }
        finally {
            this.parts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ServerMessage decodeMessage(List<ByteBuf> buffers, ConnectionContext context, DecodeContext decodeContext) {
        if (decodeContext instanceof ResultDecodeContext) {
            return ServerMessageDecoder.decodeResult(buffers, context, (ResultDecodeContext)decodeContext);
        }
        if (decodeContext instanceof FetchDecodeContext) {
            return ServerMessageDecoder.decodeFetch(buffers, context);
        }
        ByteBuf joined = JOINER.join(buffers);
        try {
            if (decodeContext instanceof CommandDecodeContext) {
                ServerMessage serverMessage = ServerMessageDecoder.decodeCommandMessage(joined, context);
                return serverMessage;
            }
            if (decodeContext instanceof PreparedMetadataDecodeContext) {
                ServerMessage serverMessage = ServerMessageDecoder.decodePreparedMetadata(joined, context, (PreparedMetadataDecodeContext)decodeContext);
                return serverMessage;
            }
            if (decodeContext instanceof PrepareQueryDecodeContext) {
                ServerMessage serverMessage = ServerMessageDecoder.decodePrepareQuery(joined);
                return serverMessage;
            }
            if (decodeContext instanceof ConnectionDecodeContext) {
                ServerMessage serverMessage = ServerMessageDecoder.decodeConnectionMessage(joined, context);
                return serverMessage;
            }
        }
        finally {
            joined.release();
        }
        throw new IllegalStateException("unknown decode context type: " + decodeContext.getClass());
    }

    @Nullable
    private static ServerMessage decodePreparedMetadata(ByteBuf buf, ConnectionContext context, PreparedMetadataDecodeContext decodeContext) {
        short header = buf.getUnsignedByte(buf.readerIndex());
        if (header == 255) {
            return ErrorMessage.decode(buf);
        }
        if (decodeContext.isInMetadata()) {
            return ServerMessageDecoder.decodeInMetadata(buf, header, context, decodeContext);
        }
        throw new R2dbcNonTransientResourceException(String.format("Unknown message header 0x%x and readable bytes is %d on prepared metadata phase", header, buf.readableBytes()));
    }

    private static ServerMessage decodeFetch(List<ByteBuf> buffers, ConnectionContext context) {
        ByteBuf firstBuf = buffers.get(0);
        short header = firstBuf.getUnsignedByte(firstBuf.readerIndex());
        ErrorMessage error = ServerMessageDecoder.decodeCheckError(buffers, header);
        if (error != null) {
            return error;
        }
        return ServerMessageDecoder.decodeRow(buffers, firstBuf, header, context, "fetch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ServerMessage decodeResult(List<ByteBuf> buffers, ConnectionContext context, ResultDecodeContext decodeContext) {
        ByteBuf firstBuf = buffers.get(0);
        short header = firstBuf.getUnsignedByte(firstBuf.readerIndex());
        ErrorMessage error = ServerMessageDecoder.decodeCheckError(buffers, header);
        if (error != null) {
            return error;
        }
        if (decodeContext.isInMetadata()) {
            ByteBuf joined = JOINER.join(buffers);
            try {
                SyntheticMetadataMessage syntheticMetadataMessage = ServerMessageDecoder.decodeInMetadata(joined, header, context, decodeContext);
                return syntheticMetadataMessage;
            }
            finally {
                joined.release();
            }
        }
        return ServerMessageDecoder.decodeRow(buffers, firstBuf, header, context, "result");
    }

    private static ServerMessage decodePrepareQuery(ByteBuf buf) {
        short header = buf.getUnsignedByte(buf.readerIndex());
        switch (header) {
            case 255: {
                return ErrorMessage.decode(buf);
            }
            case 0: {
                if (!PreparedOkMessage.isLooksLike(buf)) break;
                return PreparedOkMessage.decode(buf);
            }
        }
        throw new R2dbcNonTransientResourceException(String.format("Unknown message header 0x%x and readable bytes is %d on prepare query phase", header, buf.readableBytes()));
    }

    private static ServerMessage decodeCommandMessage(ByteBuf buf, ConnectionContext context) {
        short header = buf.getUnsignedByte(buf.readerIndex());
        switch (header) {
            case 255: {
                return ErrorMessage.decode(buf);
            }
            case 0: {
                if (!OkMessage.isValidSize(buf.readableBytes())) break;
                return OkMessage.decode(buf, context);
            }
            case 254: {
                int byteSize = buf.readableBytes();
                if (OkMessage.isValidSize(byteSize)) {
                    return OkMessage.decode(buf, context);
                }
                if (!EofMessage.isValidSize(byteSize)) break;
                return EofMessage.decode(buf);
            }
        }
        if (CodecUtils.checkNextVarInt(buf) == 0) {
            return ColumnCountMessage.decode(buf);
        }
        throw new R2dbcNonTransientResourceException(String.format("Unknown message header 0x%x and readable bytes is %d on command phase", header, buf.readableBytes()));
    }

    private static ServerMessage decodeConnectionMessage(ByteBuf buf, ConnectionContext context) {
        short header = buf.getUnsignedByte(buf.readerIndex());
        switch (header) {
            case 0: {
                if (!OkMessage.isValidSize(buf.readableBytes())) break;
                return OkMessage.decode(buf, context);
            }
            case 1: {
                return AuthMoreDataMessage.decode(buf);
            }
            case 9: 
            case 10: {
                return HandshakeRequest.decode(buf);
            }
            case 255: {
                return ErrorMessage.decode(buf);
            }
            case 254: {
                if (EofMessage.isValidSize(buf.readableBytes())) {
                    return EofMessage.decode(buf);
                }
                return AuthChangeMessage.decode(buf);
            }
        }
        throw new R2dbcPermissionDeniedException(String.format("Unknown message header 0x%x and readable bytes is %d on connection phase", header, buf.readableBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readNotFinish(ByteBuf envelope, @Nullable SequenceIdProvider.Linkable idProvider) {
        try {
            int size = envelope.readUnsignedMediumLE();
            if (size < 0xFFFFFF) {
                if (idProvider == null) {
                    envelope.skipBytes(1);
                } else {
                    idProvider.last(envelope.readUnsignedByte());
                }
                this.parts.add(envelope);
                envelope = null;
                boolean bl = false;
                return bl;
            }
            envelope.skipBytes(1);
            this.parts.add(envelope);
            envelope = null;
            boolean bl = true;
            return bl;
        }
        finally {
            if (envelope != null) {
                envelope.release();
            }
        }
    }

    private static boolean isRow(List<ByteBuf> buffers, ByteBuf firstBuf, short header) {
        if (header == 251) {
            return true;
        }
        if (header == 254) {
            if (buffers.size() > 1) {
                return true;
            }
            int size = firstBuf.readableBytes();
            return !EofMessage.isValidSize(size) && !OkMessage.isValidSize(size);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ErrorMessage decodeCheckError(List<ByteBuf> buffers, short header) {
        if (255 == header) {
            ByteBuf joined = JOINER.join(buffers);
            try {
                ErrorMessage errorMessage = ErrorMessage.decode(joined);
                return errorMessage;
            }
            finally {
                joined.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServerMessage decodeRow(List<ByteBuf> buffers, ByteBuf firstBuf, short header, ConnectionContext context, String phase) {
        if (ServerMessageDecoder.isRow(buffers, firstBuf, header)) {
            return new RowMessage(FieldReader.of(JOINER, buffers));
        }
        if (header == 254) {
            int byteSize = firstBuf.readableBytes();
            if (OkMessage.isValidSize(byteSize)) {
                ByteBuf joined = JOINER.join(buffers);
                try {
                    OkMessage okMessage = OkMessage.decode(joined, context);
                    return okMessage;
                }
                finally {
                    joined.release();
                }
            }
            if (EofMessage.isValidSize(byteSize)) {
                ByteBuf joined = JOINER.join(buffers);
                try {
                    EofMessage eofMessage = EofMessage.decode(joined);
                    return eofMessage;
                }
                finally {
                    joined.release();
                }
            }
        }
        long totalBytes = 0L;
        try {
            for (ByteBuf buffer : buffers) {
                totalBytes += (long)buffer.readableBytes();
                ReferenceCountUtil.safeRelease((Object)buffer);
            }
        }
        finally {
            buffers.clear();
        }
        throw new R2dbcNonTransientResourceException(String.format("Unknown message header 0x%x and readable bytes is %d on %s phase", header, totalBytes, phase));
    }

    @Nullable
    private static SyntheticMetadataMessage decodeInMetadata(ByteBuf buf, short header, ConnectionContext context, MetadataDecodeContext decodeContext) {
        ServerMessage message = 254 == header && EofMessage.isValidSize(buf.readableBytes()) ? EofMessage.decode(buf) : DefinitionMetadataMessage.decode(buf, context);
        if (message instanceof ServerStatusMessage) {
            context.setServerStatuses(((ServerStatusMessage)message).getServerStatuses());
        }
        return decodeContext.putPart(message);
    }
}

