/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.message.server.DefinitionMetadataMessage;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import java.util.Arrays;

public final class SyntheticMetadataMessage
implements ServerMessage {
    private final boolean completed;
    private final DefinitionMetadataMessage[] messages;

    SyntheticMetadataMessage(boolean completed, DefinitionMetadataMessage[] messages) {
        this.completed = completed;
        this.messages = AssertUtils.requireNonNull(messages, "messages must not be null");
    }

    public final DefinitionMetadataMessage[] unwrap() {
        return this.messages;
    }

    public final boolean isCompleted() {
        return this.completed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SyntheticMetadataMessage)) {
            return false;
        }
        SyntheticMetadataMessage that = (SyntheticMetadataMessage)o;
        if (this.completed != that.completed) {
            return false;
        }
        return Arrays.equals(this.messages, that.messages);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.messages);
        result = 31 * result + (this.completed ? 1 : 0);
        return result;
    }

    public String toString() {
        if (this.messages.length <= 3) {
            return String.format("SyntheticMetadataMessage{completed=%b, messages=%s}", this.completed, Arrays.toString(this.messages));
        }
        return String.format("SyntheticMetadataMessage{completed=%b, messages=[%s, %s, ...more %d messages]}", this.completed, this.messages[0], this.messages[1], this.messages.length - 2);
    }
}

