/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.util;

import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;

public final class CodecUtils {
    private static final int VAR_INT_1_BYTE_LIMIT = 250;
    private static final int VAR_INT_2_BYTE_LIMIT = 65535;
    private static final short VAR_INT_2_BYTE_CODE = 252;
    private static final int VAR_INT_3_BYTE_LIMIT = 0xFFFFFF;
    private static final short VAR_INT_3_BYTE_CODE = 253;
    static final short VAR_INT_8_BYTE_CODE = 254;
    private static final int MEDIUM_BYTES = 3;
    private static final int MEDIUM_SIZE = 24;

    private CodecUtils() {
    }

    public static String readCString(ByteBuf buf, Charset charset) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        AssertUtils.requireNonNull(charset, "charset must not be null");
        int length = buf.bytesBefore((byte)0);
        if (length < 0) {
            throw new IllegalArgumentException("buf has no C-style string terminal");
        }
        if (length == 0) {
            buf.skipBytes(1);
            return "";
        }
        String result = buf.toString(buf.readerIndex(), length, charset);
        buf.skipBytes(length + 1);
        return result;
    }

    public static ByteBuf readCStringSlice(ByteBuf buf) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        int length = buf.bytesBefore((byte)0);
        if (length < 0) {
            throw new IllegalArgumentException("buf has no C-style string");
        }
        if (length == 0) {
            buf.skipBytes(1);
            return buf.alloc().buffer(0, 0);
        }
        ByteBuf result = buf.readSlice(length);
        buf.skipBytes(1);
        return result;
    }

    public static long crossReadVarInt(ByteBuf firstPart, ByteBuf secondPart) {
        AssertUtils.requireNonNull(firstPart, "firstPart must not be null");
        AssertUtils.requireNonNull(secondPart, "secondPart must not be null");
        short firstByte = firstPart.readUnsignedByte();
        if (firstByte < 252) {
            return firstByte;
        }
        if (firstByte == 252) {
            int readable = firstPart.readableBytes();
            switch (readable) {
                case 0: {
                    return secondPart.readUnsignedShortLE();
                }
                case 1: {
                    return firstPart.readUnsignedByte() | secondPart.readUnsignedByte() << 8;
                }
            }
            return firstPart.readUnsignedShortLE();
        }
        if (firstByte == 253) {
            int readable = firstPart.readableBytes();
            switch (readable) {
                case 0: {
                    return secondPart.readUnsignedMediumLE();
                }
                case 1: {
                    return firstPart.readUnsignedByte() | secondPart.readUnsignedShortLE() << 8;
                }
                case 2: {
                    return firstPart.readUnsignedShortLE() | secondPart.readUnsignedByte() << 16;
                }
            }
            return firstPart.readUnsignedMediumLE();
        }
        return CodecUtils.crossReadLong0(firstPart, secondPart);
    }

    private static long crossReadLong0(ByteBuf firstPart, ByteBuf secondPart) {
        int readable = firstPart.readableBytes();
        if (readable == 0) {
            return secondPart.readLongLE();
        }
        switch (readable) {
            case 1: {
                long low = firstPart.readUnsignedByte();
                long middle = secondPart.readUnsignedIntLE() << 8;
                long high = (long)secondPart.readUnsignedMediumLE() << 40;
                return high | middle | low;
            }
            case 2: {
                long low = firstPart.readUnsignedShortLE();
                long middle = secondPart.readUnsignedIntLE() << 16;
                long high = (long)secondPart.readUnsignedShortLE() << 48;
                return high | middle | low;
            }
            case 3: {
                long low = firstPart.readUnsignedMediumLE();
                long middle = secondPart.readUnsignedIntLE() << 24;
                long high = (long)secondPart.readUnsignedByte() << 56;
                return high | middle | low;
            }
            case 4: {
                long low = firstPart.readUnsignedIntLE();
                long high = secondPart.readUnsignedIntLE() << 32;
                return high | low;
            }
            case 5: {
                long low = firstPart.readUnsignedIntLE();
                long middle = (long)firstPart.readUnsignedByte() << 32;
                long high = (long)secondPart.readUnsignedMediumLE() << 40;
                return high | middle | low;
            }
            case 6: {
                long low = firstPart.readUnsignedIntLE();
                long middle = (long)firstPart.readUnsignedShortLE() << 32;
                long high = (long)secondPart.readUnsignedShortLE() << 48;
                return high | middle | low;
            }
            case 7: {
                long low = firstPart.readUnsignedIntLE();
                long middle = (long)firstPart.readUnsignedMediumLE() << 32;
                long high = (long)secondPart.readUnsignedByte() << 56;
                return high | middle | low;
            }
        }
        return firstPart.readLongLE();
    }

    public static long readVarInt(ByteBuf buf) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        short firstByte = buf.readUnsignedByte();
        if (firstByte < 252) {
            return firstByte;
        }
        if (firstByte == 252) {
            return buf.readUnsignedShortLE();
        }
        if (firstByte == 253) {
            return buf.readUnsignedMediumLE();
        }
        return buf.readLongLE();
    }

    public static boolean hasNextCString(ByteBuf buf) {
        return buf.bytesBefore((byte)0) >= 0;
    }

    public static int checkNextVarInt(ByteBuf buf) {
        int byteSize = AssertUtils.requireNonNull(buf, "buf must not be null").readableBytes();
        if (byteSize <= 0) {
            return -1;
        }
        short firstByte = buf.getUnsignedByte(buf.readerIndex());
        if (firstByte < 252) {
            return byteSize - 1;
        }
        if (firstByte == 252) {
            return byteSize - 3;
        }
        if (firstByte == 253) {
            return byteSize - 4;
        }
        if (firstByte == 254) {
            return byteSize - 9;
        }
        return -1;
    }

    public static String readVarIntSizedString(ByteBuf buf, Charset charset) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        AssertUtils.requireNonNull(charset, "charset must not be null");
        int size = (int)CodecUtils.readVarInt(buf);
        if (size == 0) {
            return "";
        }
        String result = buf.toString(buf.readerIndex(), size, charset);
        buf.skipBytes(size);
        return result;
    }

    public static ByteBuf readVarIntSizedSlice(ByteBuf buf) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        int size = (int)CodecUtils.readVarInt(buf);
        if (size == 0) {
            return buf.alloc().buffer(0, 0);
        }
        return buf.readSlice(size);
    }

    public static void writeCString(ByteBuf buf, String value, Charset charset) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        AssertUtils.requireNonNull(value, "value must not be null");
        AssertUtils.requireNonNull(charset, "charset must not be null");
        if (!value.isEmpty()) {
            buf.writeCharSequence((CharSequence)value, charset);
        }
        buf.writeByte(0);
    }

    public static void writeCString(ByteBuf buf, byte[] value) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        AssertUtils.requireNonNull(value, "value must not be null");
        if (value.length > 0) {
            buf.writeBytes(value);
        }
        buf.writeByte(0);
    }

    public static void setVarInt(ByteBuf buf, int writerIndex, long value) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        AssertUtils.require(value >= 0L, "value must not be a negative integer");
        if (value <= 250L) {
            buf.setByte(writerIndex, (int)value);
        } else if (value <= 65535L) {
            buf.setByte(writerIndex, 252).setShortLE(writerIndex + 1, (int)value);
        } else if (value <= 0xFFFFFFL) {
            buf.setByte(writerIndex, 253).setMediumLE(writerIndex + 1, (int)value);
        } else {
            buf.setByte(writerIndex, 254).setLongLE(writerIndex + 1, value);
        }
    }

    public static void writeVarInt(ByteBuf buf, long value) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        AssertUtils.require(value >= 0L, "value must not be a negative integer");
        if (value <= 250L) {
            buf.writeByte((int)value);
        } else if (value <= 65535L) {
            buf.writeByte(252).writeShortLE((int)value);
        } else if (value <= 0xFFFFFFL) {
            buf.writeByte(253).writeMediumLE((int)value);
        } else {
            buf.writeByte(254).writeLongLE(value);
        }
    }

    public static int varIntBytes(long value) {
        AssertUtils.require(value >= 0L, "value must not be a negative integer");
        if (value <= 250L) {
            return 1;
        }
        if (value <= 65535L) {
            return 3;
        }
        if (value <= 0xFFFFFFL) {
            return 4;
        }
        return 9;
    }

    public static void writeVarIntSizedString(ByteBuf buf, String value, Charset charset) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        AssertUtils.requireNonNull(value, "value must not be null");
        AssertUtils.requireNonNull(charset, "charset must not be null");
        if (value.isEmpty()) {
            buf.writeByte(0);
        } else {
            CodecUtils.writeVarIntSizedBytes(buf, value.getBytes(charset));
        }
    }

    public static void writeVarIntSizedBytes(ByteBuf buf, byte[] value) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        AssertUtils.requireNonNull(value, "value must not be null");
        int size = value.length;
        if (size > 0) {
            CodecUtils.writeVarInt(buf, size);
            buf.writeBytes(value);
        } else {
            buf.writeByte(0);
        }
    }

    public static void writeVarIntSizedBytes(ByteBuf buf, ByteBuf value) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        AssertUtils.requireNonNull(value, "value must not be null");
        int size = value.readableBytes();
        if (size > 0) {
            CodecUtils.writeVarInt(buf, size);
            buf.writeBytes(value);
        } else {
            buf.writeByte(0);
        }
    }
}

