/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.PreparedExecuteMessage;
import dev.miku.r2dbc.mysql.util.OperatorUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class Binding {
    private static final ParameterValue[] EMPTY_VALUES = new ParameterValue[0];
    private final ParameterValue[] values;

    Binding(int length) {
        this.values = length == 0 ? EMPTY_VALUES : new ParameterValue[length];
    }

    void add(int index, ParameterValue value) {
        if (index < 0 || index >= this.values.length) {
            throw new IndexOutOfBoundsException("index must not be a negative integer and less than " + this.values.length);
        }
        this.values[index] = value;
    }

    PreparedExecuteMessage toMessage(int statementId, boolean immediate) {
        if (this.values.length == 0) {
            return new PreparedExecuteMessage(statementId, immediate, EMPTY_VALUES);
        }
        if (this.values[0] == null) {
            throw new IllegalStateException("Parameters has been used");
        }
        return new PreparedExecuteMessage(statementId, immediate, this.drainValues());
    }

    Mono<String> toSql(List<String> sqlParts) {
        int size = sqlParts.size() - 1;
        if (this.values.length != size || size == 0) {
            this.clear();
            return Mono.error((Throwable)new IllegalArgumentException("The number of parameter should be " + size + ", but was " + this.values.length));
        }
        if (this.values[0] == null) {
            return Mono.error((Throwable)new IllegalStateException("Parameters has been used"));
        }
        try {
            StringBuilder builder = new StringBuilder();
            Iterator<String> iter = sqlParts.iterator();
            Consumer<Object> step = ignored -> builder.append((String)iter.next());
            builder.append(iter.next());
            return OperatorUtils.discardOnCancel(Flux.fromArray((Object[])this.drainValues())).doOnDiscard(ParameterValue.class, ParameterValue.DISPOSE).concatMap(it -> it.writeTo(builder).doOnSuccess(step)).then(Mono.fromSupplier(builder::toString));
        }
        catch (Throwable e) {
            this.clear();
            throw e;
        }
    }

    void clear() {
        for (ParameterValue value : this.values) {
            this.values[i] = null;
            if (value == null) continue;
            value.dispose();
        }
    }

    int findUnbind() {
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            if (this.values[i] != null) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Binding)) {
            return false;
        }
        Binding binding = (Binding)o;
        return Arrays.equals(this.values, binding.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public String toString() {
        return String.format("Binding{values=%s}", Arrays.toString(this.values));
    }

    private ParameterValue[] drainValues() {
        ParameterValue[] results = new ParameterValue[this.values.length];
        System.arraycopy(this.values, 0, results, 0, this.values.length);
        Arrays.fill(this.values, null);
        return results;
    }

    static void clearSubsequent(Iterator<Binding> iterator) {
        while (iterator.hasNext()) {
            iterator.next().clear();
        }
    }
}

