/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.MySqlNames;
import dev.miku.r2dbc.mysql.util.InternalArrays;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;

final class ColumnNameSet
extends AbstractSet<String>
implements Set<String> {
    private final String[] names;

    ColumnNameSet(String ... names) {
        this.names = names;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof String) {
            return MySqlNames.nameSearch(this.names, (String)o) >= 0;
        }
        return false;
    }

    @Override
    public Iterator<String> iterator() {
        return InternalArrays.asIterator(this.names);
    }

    @Override
    public int size() {
        return this.names.length;
    }

    @Override
    public boolean isEmpty() {
        return this.names.length == 0;
    }

    @Override
    public Spliterator<String> spliterator() {
        return Spliterators.spliterator(this.names, 1296);
    }

    @Override
    public void forEach(Consumer<? super String> action) {
        Objects.requireNonNull(action);
        for (String name : this.names) {
            action.accept(name);
        }
    }

    public String[] toArray() {
        return Arrays.copyOf(this.names, this.names.length);
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        Objects.requireNonNull(ts);
        Object[] names = this.names;
        if (ts.length < names.length) {
            return Arrays.copyOf(names, names.length);
        }
        System.arraycopy(names, 0, ts, 0, names.length);
        if (ts.length > names.length) {
            ts[names.length] = null;
        }
        return ts;
    }

    @Override
    public boolean add(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        Objects.requireNonNull(c);
        if (!c.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super String> filter) {
        Objects.requireNonNull(filter);
        for (String name : this.names) {
            if (!filter.test(name)) continue;
            throw new UnsupportedOperationException();
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        if (!c.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        if (!c.containsAll(this)) {
            throw new UnsupportedOperationException();
        }
        return false;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return Arrays.toString(this.names);
    }
}

