/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.MySqlConnectionConfiguration;
import dev.miku.r2dbc.mysql.MySqlConnectionFactory;
import dev.miku.r2dbc.mysql.constant.SslMode;
import dev.miku.r2dbc.mysql.constant.ZeroDateOption;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import io.r2dbc.spi.Option;
import java.time.Duration;
import java.util.function.Predicate;

public final class MySqlConnectionFactoryProvider
implements ConnectionFactoryProvider {
    public static final String MYSQL_DRIVER = "mysql";
    public static final Option<String> UNIX_SOCKET = Option.valueOf((String)"unixSocket");
    public static final Option<String> ZERO_DATE = Option.valueOf((String)"zeroDate");
    public static final Option<String> SSL_MODE = Option.valueOf((String)"sslMode");
    public static final Option<String> TLS_VERSION = Option.valueOf((String)"tlsVersion");
    public static final Option<String> SSL_CA = Option.valueOf((String)"sslCa");
    public static final Option<String> SSL_KEY = Option.valueOf((String)"sslKey");
    public static final Option<CharSequence> SSL_KEY_PASSWORD = Option.sensitiveValueOf((String)"sslKeyPassword");
    public static final Option<String> SSL_CERT = Option.valueOf((String)"sslCert");
    public static final Option<Object> USE_SERVER_PREPARE_STATEMENT = Option.valueOf((String)"useServerPrepareStatement");

    public ConnectionFactory create(ConnectionFactoryOptions options) {
        String tlsVersion;
        String sslMode;
        Boolean isSsl;
        Integer port;
        AssertUtils.requireNonNull(options, "connectionFactoryOptions must not be null");
        MySqlConnectionConfiguration.Builder builder = MySqlConnectionConfiguration.builder();
        String zeroDate = (String)options.getValue(ZERO_DATE);
        if (zeroDate != null) {
            builder.zeroDateOption(ZeroDateOption.valueOf(zeroDate.toUpperCase()));
        }
        if ((port = (Integer)options.getValue(ConnectionFactoryOptions.PORT)) != null) {
            builder.port(port);
        }
        if ((isSsl = (Boolean)options.getValue(ConnectionFactoryOptions.SSL)) != null) {
            builder.sslMode(isSsl != false ? SslMode.PREFERRED : SslMode.DISABLED);
        }
        if ((sslMode = (String)options.getValue(SSL_MODE)) != null) {
            builder.sslMode(SslMode.valueOf(sslMode.toUpperCase()));
        }
        if ((tlsVersion = (String)options.getValue(TLS_VERSION)) != null) {
            builder.tlsVersion(tlsVersion.split(","));
        }
        String sslCert = (String)options.getValue(SSL_CERT);
        String sslKey = (String)options.getValue(SSL_KEY);
        CharSequence sslKeyPassword = (CharSequence)options.getValue(SSL_KEY_PASSWORD);
        if (sslKey != null || sslCert != null) {
            AssertUtils.require(sslKey != null && sslCert != null, "SSL key and cert must be both null or both non-null");
            builder.sslKeyAndCert(sslCert, sslKey, sslKeyPassword);
        }
        String unixSocket = (String)options.getValue(UNIX_SOCKET);
        String host = (String)options.getValue(ConnectionFactoryOptions.HOST);
        if (unixSocket == null) {
            AssertUtils.requireNonNull(host, "host must not be null when unixSocket is null");
            builder.host(host);
        } else {
            builder.unixSocket(unixSocket);
        }
        Object serverPreparing = options.getValue(USE_SERVER_PREPARE_STATEMENT);
        if (serverPreparing != null) {
            if (serverPreparing instanceof String) {
                String value = (String)serverPreparing;
                serverPreparing = "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value) ? Boolean.valueOf(Boolean.parseBoolean(value)) : MySqlConnectionFactoryProvider.convertPredicate(value);
            }
            if (serverPreparing instanceof Boolean) {
                if (((Boolean)serverPreparing).booleanValue()) {
                    builder.useServerPrepareStatement();
                } else {
                    builder.useClientPrepareStatement();
                }
            } else if (serverPreparing instanceof Predicate) {
                builder.useServerPrepareStatement((Predicate)serverPreparing);
            }
        }
        MySqlConnectionConfiguration configuration = builder.username((String)options.getRequiredValue(ConnectionFactoryOptions.USER)).password((CharSequence)options.getValue(ConnectionFactoryOptions.PASSWORD)).connectTimeout((Duration)options.getValue(ConnectionFactoryOptions.CONNECT_TIMEOUT)).database((String)options.getValue(ConnectionFactoryOptions.DATABASE)).sslCa((String)options.getValue(SSL_CA)).build();
        return MySqlConnectionFactory.from(configuration);
    }

    public boolean supports(ConnectionFactoryOptions options) {
        AssertUtils.requireNonNull(options, "connectionFactoryOptions must not be null");
        return MYSQL_DRIVER.equals(options.getValue(ConnectionFactoryOptions.DRIVER));
    }

    public String getDriver() {
        return MYSQL_DRIVER;
    }

    private static Predicate<String> convertPredicate(String className) {
        try {
            Class<?> type = Class.forName(className);
            if (Predicate.class.isAssignableFrom(type)) {
                return (Predicate)type.newInstance();
            }
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Cannot instantiate '" + className + "'", e);
        }
        throw new IllegalArgumentException("Value '" + className + "' must be an instance of Predicate");
    }
}

