/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.constant.SslMode;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.InternalArrays;
import java.util.Arrays;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class MySqlSslConfiguration {
    private static final MySqlSslConfiguration DISABLED = new MySqlSslConfiguration(SslMode.DISABLED, InternalArrays.EMPTY_STRINGS, null, null, null, null);
    private final SslMode sslMode;
    private final String[] tlsVersion;
    @Nullable
    private final String sslCa;
    @Nullable
    private final String sslKey;
    @Nullable
    private final CharSequence sslKeyPassword;
    @Nullable
    private final String sslCert;

    private MySqlSslConfiguration(SslMode sslMode, String[] tlsVersion, @Nullable String sslCa, @Nullable String sslKey, @Nullable CharSequence sslKeyPassword, @Nullable String sslCert) {
        this.sslMode = sslMode;
        this.tlsVersion = tlsVersion;
        this.sslCa = sslCa;
        this.sslKey = sslKey;
        this.sslKeyPassword = sslKeyPassword;
        this.sslCert = sslCert;
    }

    public SslMode getSslMode() {
        return this.sslMode;
    }

    public String[] getTlsVersion() {
        return this.tlsVersion;
    }

    @Nullable
    public String getSslCa() {
        return this.sslCa;
    }

    @Nullable
    public String getSslKey() {
        return this.sslKey;
    }

    @Nullable
    public CharSequence getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    @Nullable
    public String getSslCert() {
        return this.sslCert;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlSslConfiguration)) {
            return false;
        }
        MySqlSslConfiguration that = (MySqlSslConfiguration)o;
        return this.sslMode == that.sslMode && Arrays.equals(this.tlsVersion, that.tlsVersion) && Objects.equals(this.sslCa, that.sslCa) && Objects.equals(this.sslKey, that.sslKey) && Objects.equals(this.sslKeyPassword, that.sslKeyPassword) && Objects.equals(this.sslCert, that.sslCert);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.sslMode, this.sslCa, this.sslKey, this.sslKeyPassword, this.sslCert});
        result = 31 * result + Arrays.hashCode(this.tlsVersion);
        return result;
    }

    public String toString() {
        if (this.sslMode.startSsl()) {
            return String.format("MySqlSslConfiguration{sslMode=%s, tlsVersion=%s, sslCa='%s', sslKey='%s', sslKeyPassword=REDACTED, sslCert='%s'}", new Object[]{this.sslMode, Arrays.toString(this.tlsVersion), this.sslCa, this.sslKey, this.sslCert});
        }
        return "DISABLED";
    }

    static MySqlSslConfiguration disabled() {
        return DISABLED;
    }

    static MySqlSslConfiguration create(SslMode sslMode, String[] tlsVersion, @Nullable String sslCa, @Nullable String sslKey, @Nullable CharSequence sslKeyPassword, @Nullable String sslCert) {
        AssertUtils.requireNonNull(sslMode, "sslMode must not be null");
        if (!sslMode.startSsl()) {
            return DISABLED;
        }
        AssertUtils.requireNonNull(tlsVersion, "tlsVersion must not be null");
        AssertUtils.require(!sslMode.verifyCertificate() || sslCa != null, "sslCa must not be null when verifying mode has set");
        AssertUtils.require(sslKey == null && sslCert == null || sslKey != null && sslCert != null, "sslKey and cert must be both null or both non-null");
        return new MySqlSslConfiguration(sslMode, tlsVersion, sslCa, sslKey, sslKeyPassword, sslCert);
    }
}

