/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.Binding;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import java.util.Arrays;
import reactor.util.annotation.Nullable;

final class ParameterIndex {
    private static final int INIT_CAPACITY = 4;
    private final int first;
    @Nullable
    private int[] values;
    private int size = 1;

    ParameterIndex(int first) {
        this.first = first;
    }

    void push(int value) {
        if (this.values == null) {
            int[] data = new int[4];
            data[0] = this.first;
            data[1] = value;
            this.values = data;
            this.size = 2;
        } else {
            int i;
            if ((i = this.size++) >= this.values.length) {
                int[] data = new int[this.values.length << 1];
                System.arraycopy(this.values, 0, data, 0, this.values.length);
                this.values = data;
            }
            this.values[i] = value;
        }
    }

    void bind(Binding binding, ParameterValue value) {
        if (this.values == null) {
            binding.add(this.first, value);
        } else {
            for (int i = 0; i < this.size; ++i) {
                binding.add(this.values[i], value);
            }
        }
    }

    int[] toIntArray() {
        if (this.values == null) {
            return new int[]{this.first};
        }
        return Arrays.copyOf(this.values, this.size);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterIndex)) {
            return false;
        }
        ParameterIndex that = (ParameterIndex)o;
        if (this.first != that.first) {
            return false;
        }
        if (this.size != that.size) {
            return false;
        }
        return Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        int result = this.first;
        result = 31 * result + Arrays.hashCode(this.values);
        result = 31 * result + this.size;
        return result;
    }

    public String toString() {
        if (this.values == null) {
            return Integer.toString(this.first);
        }
        StringBuilder builder = new StringBuilder().append('[').append(this.values[0]);
        for (int i = 1; i < this.size; ++i) {
            builder.append(", ").append(this.values[i]);
        }
        return builder.append(']').toString();
    }
}

