/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.Binding;
import dev.miku.r2dbc.mysql.MySqlResult;
import dev.miku.r2dbc.mysql.MySqlStatement;
import dev.miku.r2dbc.mysql.ParameterIndex;
import dev.miku.r2dbc.mysql.ParametrizedStatementSupport;
import dev.miku.r2dbc.mysql.PrepareQuery;
import dev.miku.r2dbc.mysql.QueryFlow;
import dev.miku.r2dbc.mysql.client.Client;
import dev.miku.r2dbc.mysql.codec.Codecs;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class PrepareParametrizedStatement
extends ParametrizedStatementSupport {
    private final PrepareQuery query;
    private final boolean deprecateEof;
    private int fetchSize = 0;

    PrepareParametrizedStatement(Client client, Codecs codecs, ConnectionContext context, PrepareQuery query, boolean deprecateEof) {
        super(client, codecs, context, AssertUtils.requireNonNull(query, "query must not be null").getParameters());
        this.query = query;
        this.deprecateEof = deprecateEof;
    }

    @Override
    public Flux<MySqlResult> execute(List<Binding> bindings) {
        String sql = this.query.getSql();
        return QueryFlow.prepare(this.client, sql).doOnCancel(bindings::clear).flatMapMany(it -> QueryFlow.execute(this.client, this.context, sql, it, this.deprecateEof, this.fetchSize, bindings).map(messages -> new MySqlResult(true, this.codecs, this.context, this.generatedKeyName, (Flux<ServerMessage>)messages)).onErrorResume(e -> it.close().then(Mono.error((Throwable)e))).concatWith((Publisher)it.close().then(Mono.empty())).doOnCancel(() -> it.close().subscribe()));
    }

    @Override
    public MySqlStatement fetchSize(int rows) {
        AssertUtils.require(rows >= 0, "Fetch size must be greater or equal to zero");
        this.fetchSize = rows;
        return this;
    }

    @Override
    protected ParameterIndex getIndexes(String name) {
        return this.query.getIndexes(name);
    }
}

