/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.Binding;
import dev.miku.r2dbc.mysql.MySqlResult;
import dev.miku.r2dbc.mysql.MySqlStatement;
import dev.miku.r2dbc.mysql.QueryFlow;
import dev.miku.r2dbc.mysql.SimpleStatementSupport;
import dev.miku.r2dbc.mysql.client.Client;
import dev.miku.r2dbc.mysql.codec.Codecs;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class PrepareSimpleStatement
extends SimpleStatementSupport {
    private static final List<Binding> BINDINGS = Collections.singletonList(new Binding(0));
    private final boolean deprecateEof;
    private int fetchSize = 0;

    PrepareSimpleStatement(Client client, Codecs codecs, ConnectionContext context, String sql, boolean deprecateEof) {
        super(client, codecs, context, sql);
        this.deprecateEof = deprecateEof;
    }

    public Flux<MySqlResult> execute() {
        return Flux.defer(() -> QueryFlow.prepare(this.client, this.sql).flatMapMany(it -> QueryFlow.execute(this.client, this.context, this.sql, it, this.deprecateEof, this.fetchSize, BINDINGS).map(messages -> new MySqlResult(true, this.codecs, this.context, this.generatedKeyName, (Flux<ServerMessage>)messages)).onErrorResume(e -> it.close().then(Mono.error((Throwable)e))).concatWith((Publisher)it.close().then(Mono.empty())).doOnCancel(() -> it.close().subscribe())));
    }

    @Override
    public MySqlStatement fetchSize(int rows) {
        AssertUtils.require(rows >= 0, "Fetch size must be greater or equal to zero");
        this.fetchSize = rows;
        return this;
    }
}

