/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.Binding;
import dev.miku.r2dbc.mysql.MySqlResult;
import dev.miku.r2dbc.mysql.ParameterIndex;
import dev.miku.r2dbc.mysql.ParametrizedStatementSupport;
import dev.miku.r2dbc.mysql.QueryFlow;
import dev.miku.r2dbc.mysql.TextQuery;
import dev.miku.r2dbc.mysql.client.Client;
import dev.miku.r2dbc.mysql.codec.Codecs;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import java.util.List;
import java.util.function.Function;
import reactor.core.publisher.Flux;

final class TextParametrizedStatement
extends ParametrizedStatementSupport {
    private final TextQuery query;

    TextParametrizedStatement(Client client, Codecs codecs, ConnectionContext context, TextQuery query) {
        super(client, codecs, context, AssertUtils.requireNonNull(query, "query must not be null").getParameters());
        this.query = query;
    }

    @Override
    protected Flux<MySqlResult> execute(List<Binding> bindings) {
        Function<Flux, MySqlResult> toResult = messages -> new MySqlResult(false, this.codecs, this.context, this.generatedKeyName, (Flux<ServerMessage>)messages);
        return this.query.formatSql(bindings).concatMap(it -> QueryFlow.execute(this.client, it).map(toResult), 1);
    }

    @Override
    protected ParameterIndex getIndexes(String name) {
        return this.query.getIndexes(name);
    }
}

