/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.authentication;

import dev.miku.r2dbc.mysql.authentication.AuthHelper;
import dev.miku.r2dbc.mysql.authentication.MySqlAuthProvider;
import dev.miku.r2dbc.mysql.collation.CharCollation;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import java.nio.CharBuffer;
import reactor.util.annotation.Nullable;

final class CachingSha2FullAuthProvider
implements MySqlAuthProvider {
    static final CachingSha2FullAuthProvider INSTANCE = new CachingSha2FullAuthProvider();

    private CachingSha2FullAuthProvider() {
    }

    @Override
    public boolean isSslNecessary() {
        return true;
    }

    @Override
    public byte[] authentication(@Nullable CharSequence password, @Nullable byte[] salt, CharCollation collation) {
        if (password == null || password.length() <= 0) {
            return new byte[]{0};
        }
        AssertUtils.requireNonNull(collation, "collation must not be null when password exists");
        return AuthHelper.encodeTerminal(CharBuffer.wrap(password), collation.getCharset());
    }

    @Override
    public MySqlAuthProvider next() {
        return this;
    }

    @Override
    public String getType() {
        return "caching_sha2_password";
    }
}

