/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.client;

import dev.miku.r2dbc.mysql.MySqlSslConfiguration;
import dev.miku.r2dbc.mysql.client.ReactorNettyClient;
import dev.miku.r2dbc.mysql.message.client.ExchangeableMessage;
import dev.miku.r2dbc.mysql.message.client.SendOnlyMessage;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.channel.ChannelOption;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.function.Predicate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.tcp.TcpClient;
import reactor.util.annotation.Nullable;

public interface Client {
    public Flux<ServerMessage> exchange(ExchangeableMessage var1, Predicate<ServerMessage> var2);

    public Mono<Void> sendOnly(SendOnlyMessage var1);

    public Mono<ServerMessage> receiveOnly();

    public Mono<Void> close();

    public Mono<Void> forceClose();

    public boolean isConnected();

    public void sslUnsupported();

    public void loginSuccess();

    public static Mono<Client> connect(SocketAddress address, MySqlSslConfiguration ssl, ConnectionContext context, @Nullable Duration connectTimeout) {
        AssertUtils.requireNonNull(address, "address must not be null");
        AssertUtils.requireNonNull(ssl, "ssl must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        return TcpClient.newConnection().bootstrap(b -> {
            if (connectTimeout != null) {
                b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.toIntExact(connectTimeout.toMillis()));
            }
            return b.remoteAddress(address);
        }).connect().map(conn -> new ReactorNettyClient((Connection)conn, ssl, context));
    }
}

