/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.client;

import dev.miku.r2dbc.mysql.message.client.ClientMessage;
import java.util.function.Supplier;
import reactor.core.Disposable;
import reactor.core.publisher.MonoSink;
import reactor.util.annotation.Nullable;

final class RequestTask<T> {
    @Nullable
    private final Disposable disposable;
    private final MonoSink<T> sink;
    private final Supplier<T> supplier;

    private RequestTask(@Nullable Disposable disposable, MonoSink<T> sink, Supplier<T> supplier) {
        this.disposable = disposable;
        this.sink = sink;
        this.supplier = supplier;
    }

    void run() {
        this.sink.success(this.supplier.get());
    }

    void cancel(Throwable e) {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
        this.sink.error(e);
    }

    static <T> RequestTask<T> wrap(ClientMessage message, MonoSink<T> sink, Supplier<T> supplier) {
        if (message instanceof Disposable) {
            return new RequestTask<T>((Disposable)message, sink, supplier);
        }
        return new RequestTask<T>(null, sink, supplier);
    }

    static <T> RequestTask<T> wrap(Disposable disposable, MonoSink<T> sink, Supplier<T> supplier) {
        return new RequestTask<T>(disposable, sink, supplier);
    }

    static <T> RequestTask<T> wrap(MonoSink<T> sink, Supplier<T> supplier) {
        return new RequestTask<T>(null, sink, supplier);
    }
}

