/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.client;

import dev.miku.r2dbc.mysql.MySqlSslConfiguration;
import dev.miku.r2dbc.mysql.client.MySqlHostVerifier;
import dev.miku.r2dbc.mysql.client.SslState;
import dev.miku.r2dbc.mysql.constant.SslMode;
import dev.miku.r2dbc.mysql.message.server.SyntheticSslResponseMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import dev.miku.r2dbc.mysql.util.ServerVersion;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.netty.tcp.SslProvider;

final class SslBridgeHandler
extends ChannelDuplexHandler {
    static final String NAME = "R2dbcMySqlSslBridgeHandler";
    private static final String SSL_NAME = "R2dbcMySqlSslHandler";
    private static final Logger logger = LoggerFactory.getLogger(SslBridgeHandler.class);
    private static final ServerVersion TLS1_2_COMMUNITY_VER = ServerVersion.create(8, 0, 4);
    private static final ServerVersion TLS1_2_ENTERPRISE_VER = ServerVersion.create(5, 6, 0);
    private final ConnectionContext context;
    private final boolean verifyIdentity;
    private volatile SSLEngine sslEngine;
    private volatile MySqlSslConfiguration ssl;

    SslBridgeHandler(ConnectionContext context, MySqlSslConfiguration ssl) {
        this.context = AssertUtils.requireNonNull(context, "context must not be null");
        this.ssl = AssertUtils.requireNonNull(ssl, "ssl must not be null");
        this.verifyIdentity = ssl.getSslMode().verifyIdentity();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslState) {
            this.handleSslState(ctx, (SslState)((Object)evt));
            return;
        }
        if (SslHandshakeCompletionEvent.SUCCESS == evt) {
            this.handleSslCompleted(ctx);
        }
        super.userEventTriggered(ctx, evt);
    }

    private void handleSslCompleted(ChannelHandlerContext ctx) {
        if (this.verifyIdentity) {
            SSLEngine sslEngine = this.sslEngine;
            String hostname = ((InetSocketAddress)ctx.channel().remoteAddress()).getHostName();
            if (sslEngine == null) {
                ctx.fireExceptionCaught((Throwable)new IllegalStateException("sslEngine must not be null when verify identity"));
                return;
            }
            try {
                MySqlHostVerifier.accept(hostname, sslEngine.getSession());
            }
            catch (Exception e) {
                ctx.fireExceptionCaught((Throwable)e);
                return;
            }
        }
        ctx.fireChannelRead((Object)SyntheticSslResponseMessage.getInstance());
        logger.debug("SSL handshake completed, remove SSL bridge in pipeline");
        ctx.pipeline().remove(NAME);
    }

    private void handleSslState(ChannelHandlerContext ctx, SslState state) {
        switch (state) {
            case BRIDGING: {
                logger.debug("SSL event triggered, enable SSL handler to pipeline");
                MySqlSslConfiguration ssl = this.ssl;
                this.ssl = null;
                if (ssl == null) {
                    ctx.fireExceptionCaught((Throwable)new IllegalStateException("The SSL bridge has used, cannot build SSL handler twice"));
                    return;
                }
                SslProvider sslProvider = SslBridgeHandler.buildProvider(ssl, this.context.getServerVersion());
                SslHandler sslHandler = sslProvider.getSslContext().newHandler(ctx.alloc());
                this.sslEngine = sslHandler.engine();
                ctx.pipeline().addBefore(NAME, SSL_NAME, (ChannelHandler)sslHandler);
                break;
            }
            case UNSUPPORTED: {
                logger.debug("Server unsupported SSL, remove SSL bridge in pipeline");
                ctx.pipeline().remove(NAME);
            }
        }
    }

    private static SslProvider buildProvider(MySqlSslConfiguration ssl, ServerVersion version) {
        return SslProvider.builder().sslContext(SslBridgeHandler.buildContext(ssl, version)).defaultConfiguration(SslProvider.DefaultConfigurationType.TCP).build();
    }

    private static SslContextBuilder buildContext(MySqlSslConfiguration ssl, ServerVersion version) {
        SslMode mode;
        SslContextBuilder builder = SslBridgeHandler.withTlsVersion(SslContextBuilder.forClient(), ssl, version);
        String sslKey = ssl.getSslKey();
        if (sslKey != null) {
            CharSequence keyPassword = ssl.getSslKeyPassword();
            String sslCert = ssl.getSslCert();
            if (sslCert == null) {
                throw new IllegalStateException("SSL key param requires but SSL cert param to be present");
            }
            builder.keyManager(new File(sslCert), new File(sslKey), keyPassword == null ? null : keyPassword.toString());
        }
        if ((mode = ssl.getSslMode()).verifyCertificate()) {
            String sslCa = ssl.getSslCa();
            if (sslCa == null) {
                throw new IllegalStateException(String.format("SSL mode %s requires SSL CA parameter", new Object[]{mode}));
            }
            builder.trustManager(new File(sslCa));
        } else {
            builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        return builder;
    }

    private static SslContextBuilder withTlsVersion(SslContextBuilder builder, MySqlSslConfiguration ssl, ServerVersion version) {
        String[] tlsProtocols = ssl.getTlsVersion();
        if (tlsProtocols.length > 0) {
            builder.protocols(tlsProtocols);
        } else if (SslBridgeHandler.isEnabledTls1_2(version)) {
            builder.protocols(new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
        } else {
            builder.protocols(new String[]{"TLSv1", "TLSv1.1"});
        }
        return builder;
    }

    private static boolean isEnabledTls1_2(ServerVersion version) {
        return version.isGreaterThanOrEqualTo(TLS1_2_COMMUNITY_VER) || version.isGreaterThanOrEqualTo(TLS1_2_ENTERPRISE_VER) && version.isEnterprise();
    }
}

