/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.PrimitiveCodec;
import dev.miku.r2dbc.mysql.message.FieldValue;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import java.lang.reflect.Type;

abstract class AbstractPrimitiveCodec<T>
implements PrimitiveCodec<T> {
    private final Class<T> primitiveClass;
    private final Class<T> boxedClass;

    AbstractPrimitiveCodec(Class<T> primitiveClass, Class<T> boxedClass) {
        if (!primitiveClass.isPrimitive() || boxedClass.isPrimitive()) {
            throw new IllegalArgumentException("primitiveClass must be primitive and boxedClass must not be primitive");
        }
        this.primitiveClass = primitiveClass;
        this.boxedClass = boxedClass;
    }

    @Override
    public final boolean canDecode(FieldValue value, FieldInformation info, Type target) {
        if (!(target instanceof Class) || !(value instanceof NormalFieldValue)) {
            return false;
        }
        return ((Class)target).isAssignableFrom(this.boxedClass) && this.doCanDecode(info);
    }

    @Override
    public final boolean canPrimitiveDecode(FieldInformation info) {
        return this.doCanDecode(info);
    }

    @Override
    public final Class<T> getPrimitiveClass() {
        return this.primitiveClass;
    }

    protected abstract boolean doCanDecode(FieldInformation var1);
}

