/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.CodecUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import dev.miku.r2dbc.mysql.util.InternalArrays;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.BitSet;
import reactor.core.publisher.Mono;

final class BitSetCodec
extends AbstractClassedCodec<BitSet> {
    static final BitSetCodec INSTANCE = new BitSetCodec();

    private BitSetCodec() {
        super(BitSet.class);
    }

    @Override
    public BitSet decode(NormalFieldValue value, FieldInformation info, Class<? super BitSet> target, boolean binary, ConnectionContext context) {
        ByteBuf buf = value.getBufferSlice();
        if (!buf.isReadable()) {
            return BitSet.valueOf(InternalArrays.EMPTY_BYTES);
        }
        return BitSet.valueOf(BitSetCodec.reverse(ByteBufUtil.getBytes((ByteBuf)buf)));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof BitSet;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return new BitSetValue((BitSet)value);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        return 16 == info.getType();
    }

    private static byte[] reverse(byte[] bytes) {
        int maxIndex = bytes.length - 1;
        int half = bytes.length >>> 1;
        for (int i = 0; i < half; ++i) {
            byte b = bytes[i];
            bytes[i] = bytes[maxIndex - i];
            bytes[maxIndex - i] = b;
        }
        return bytes;
    }

    private static final class BitSetValue
    extends AbstractParameterValue {
        private final BitSet set;

        private BitSetValue(BitSet set) {
            this.set = set;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeByteArray(BitSetCodec.reverse(this.set.toByteArray())));
        }

        @Override
        public Mono<Void> writeTo(StringBuilder builder) {
            return Mono.fromRunnable(() -> {
                if (this.set.isEmpty()) {
                    builder.append("b'0'");
                } else {
                    builder.append('x').append('\'');
                    CodecUtils.appendHex(builder, BitSetCodec.reverse(this.set.toByteArray()));
                    builder.append('\'');
                }
            });
        }

        @Override
        public short getType() {
            return 16;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BitSetValue)) {
                return false;
            }
            BitSetValue that = (BitSetValue)o;
            return this.set.equals(that.set);
        }

        public int hashCode() {
            return this.set.hashCode();
        }
    }
}

