/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import reactor.core.publisher.Mono;

final class BooleanCodec
extends AbstractPrimitiveCodec<Boolean> {
    static final BooleanCodec INSTANCE = new BooleanCodec();

    private BooleanCodec() {
        super(Boolean.TYPE, Boolean.class);
    }

    @Override
    public Boolean decode(NormalFieldValue value, FieldInformation info, Class<? super Boolean> target, boolean binary, ConnectionContext context) {
        return value.getBufferSlice().readBoolean();
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Boolean;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return (Boolean)value != false ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    @Override
    public boolean doCanDecode(FieldInformation info) {
        return 16 == info.getType() && info.getSize() == 1L;
    }

    private static final class BooleanValue
    extends AbstractParameterValue {
        private static final BooleanValue TRUE = new BooleanValue(true);
        private static final BooleanValue FALSE = new BooleanValue(false);
        private final boolean value;

        private BooleanValue(boolean value) {
            this.value = value;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeBoolean(this.value));
        }

        @Override
        public Mono<Void> writeTo(StringBuilder builder) {
            return Mono.fromRunnable(() -> builder.append(this.value ? "b'1'" : "b'0'"));
        }

        @Override
        public short getType() {
            return 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BooleanValue)) {
                return false;
            }
            BooleanValue that = (BooleanValue)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return this.value ? 1 : 0;
        }
    }
}

