/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.TypePredicates;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.CodecUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import dev.miku.r2dbc.mysql.util.InternalArrays;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import reactor.core.publisher.Mono;

final class ByteBufferCodec
extends AbstractClassedCodec<ByteBuffer> {
    static final ByteBufferCodec INSTANCE = new ByteBufferCodec();

    private ByteBufferCodec() {
        super(ByteBuffer.class);
    }

    @Override
    public ByteBuffer decode(NormalFieldValue value, FieldInformation info, Class<? super ByteBuffer> target, boolean binary, ConnectionContext context) {
        ByteBuf buf = value.getBufferSlice();
        if (!buf.isReadable()) {
            return ByteBuffer.wrap(InternalArrays.EMPTY_BYTES);
        }
        ByteBuffer result = ByteBuffer.allocate(buf.readableBytes());
        buf.readBytes(result);
        result.flip();
        return result;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return new ByteBufferValue((ByteBuffer)value);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof ByteBuffer;
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        return TypePredicates.isBinary(info.getType());
    }

    private static final class ByteBufferValue
    extends AbstractParameterValue {
        private final ByteBuffer buffer;

        private ByteBufferValue(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeByteBuffer(this.buffer));
        }

        @Override
        public Mono<Void> writeTo(StringBuilder builder) {
            return Mono.fromRunnable(() -> {
                builder.append('x').append('\'');
                CodecUtils.appendHex(builder, this.buffer);
                builder.append('\'');
            });
        }

        @Override
        public short getType() {
            return 251;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByteBufferValue)) {
                return false;
            }
            ByteBufferValue that = (ByteBufferValue)o;
            return this.buffer.equals(that.buffer);
        }

        public int hashCode() {
            return this.buffer.hashCode();
        }
    }
}

