/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.IntegerCodec;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import reactor.core.publisher.Mono;

final class ByteCodec
extends AbstractPrimitiveCodec<Byte> {
    static final ByteCodec INSTANCE = new ByteCodec();

    private ByteCodec() {
        super(Byte.TYPE, Byte.class);
    }

    @Override
    public Byte decode(NormalFieldValue value, FieldInformation info, Class<? super Byte> target, boolean binary, ConnectionContext context) {
        if (binary) {
            return value.getBufferSlice().readByte();
        }
        return (byte)IntegerCodec.parse(value.getBufferSlice());
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Byte;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return new ByteValue((Byte)value);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        return 1 == info.getType() && (info.getDefinitions() & 0x20) == 0;
    }

    static final class ByteValue
    extends AbstractParameterValue {
        private final byte value;

        ByteValue(byte value) {
            this.value = value;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeByte(this.value));
        }

        @Override
        public Mono<Void> writeTo(StringBuilder builder) {
            return Mono.fromRunnable(() -> builder.append(this.value));
        }

        @Override
        public short getType() {
            return 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByteValue)) {
                return false;
            }
            ByteValue byteValue = (ByteValue)o;
            return this.value == byteValue.value;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

