/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.constant.ZeroDateOption;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.nio.charset.StandardCharsets;
import java.time.temporal.Temporal;
import reactor.util.annotation.Nullable;

final class CodecDateUtils {
    static int readIntInDigits(ByteBuf buf) {
        if (!buf.isReadable()) {
            return 0;
        }
        int readerIndex = buf.readerIndex();
        int writerIndex = buf.writerIndex();
        int result = 0;
        for (int i = readerIndex; i < writerIndex; ++i) {
            byte digit = buf.getByte(i);
            if (digit < 48 || digit > 57) {
                buf.readerIndex(i + 1);
                return result;
            }
            result = result * 10 + (digit - 48);
        }
        buf.readerIndex(writerIndex);
        return result;
    }

    @Nullable
    static <T extends Temporal> T handle(ZeroDateOption option, boolean binary, ByteBuf buf, int index, int bytes, T round) {
        switch (option) {
            case USE_NULL: {
                return null;
            }
            case USE_ROUND: {
                return round;
            }
        }
        String message = binary ? String.format("Binary value %s (hex dump) invalid and ZeroDateOption is %s", ByteBufUtil.hexDump((ByteBuf)buf, (int)index, (int)bytes), ZeroDateOption.EXCEPTION.name()) : String.format("Text value '%s' invalid and ZeroDateOption is %s", buf.toString(StandardCharsets.US_ASCII), ZeroDateOption.EXCEPTION.name());
        throw new R2dbcNonTransientResourceException(message, "S1009");
    }

    private CodecDateUtils() {
    }
}

