/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.Codec;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.collation.CharCollation;
import dev.miku.r2dbc.mysql.message.FieldValue;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.CodecUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import reactor.core.publisher.Mono;

final class EnumCodec
implements Codec<Enum<?>, NormalFieldValue, Class<?>> {
    static final EnumCodec INSTANCE = new EnumCodec();

    private EnumCodec() {
    }

    @Override
    public Enum<?> decode(NormalFieldValue value, FieldInformation info, Class<?> target, boolean binary, ConnectionContext context) {
        Charset charset = CharCollation.fromId(info.getCollationId(), context.getServerVersion()).getCharset();
        Object e = Enum.valueOf(target, value.getBufferSlice().toString(charset));
        return e;
    }

    @Override
    public boolean canDecode(FieldValue value, FieldInformation info, Type target) {
        if (247 == info.getType() && target instanceof Class && value instanceof NormalFieldValue) {
            return ((Class)target).isEnum();
        }
        return false;
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Enum;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return new EnumValue((Enum)value, context);
    }

    private static final class EnumValue
    extends AbstractParameterValue {
        private final Enum<?> value;
        private final ConnectionContext context;

        private EnumValue(Enum<?> value, ConnectionContext context) {
            this.value = value;
            this.context = context;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeCharSequence(this.value.name(), this.context.getCollation()));
        }

        @Override
        public Mono<Void> writeTo(StringBuilder builder) {
            return Mono.fromRunnable(() -> {
                builder.append('\'');
                CodecUtils.appendEscape(builder, this.value.name());
                builder.append('\'');
            });
        }

        @Override
        public short getType() {
            return 15;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EnumValue)) {
                return false;
            }
            EnumValue enumValue = (EnumValue)o;
            return this.value.equals(enumValue.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

