/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.CodecDateUtils;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.LocalDateCodec;
import dev.miku.r2dbc.mysql.codec.LocalTimeCodec;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.concurrent.TimeUnit;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

final class LocalDateTimeCodec
extends AbstractClassedCodec<LocalDateTime> {
    private static final LocalDateTime ROUND = LocalDateTime.of(LocalDateCodec.ROUND, LocalTime.MIN);
    static final LocalDateTimeCodec INSTANCE = new LocalDateTimeCodec();

    private LocalDateTimeCodec() {
        super(LocalDateTime.class);
    }

    @Override
    public LocalDateTime decode(NormalFieldValue value, FieldInformation info, Class<? super LocalDateTime> target, boolean binary, ConnectionContext context) {
        ByteBuf buf = value.getBufferSlice();
        int index = buf.readerIndex();
        int bytes = buf.readableBytes();
        if (binary) {
            LocalDateTime dateTime = LocalDateTimeCodec.decodeBinary(buf, bytes);
            if (dateTime == null) {
                return CodecDateUtils.handle(context.getZeroDateOption(), true, buf, index, bytes, ROUND);
            }
            return dateTime;
        }
        LocalDateTime dateTime = LocalDateTimeCodec.decodeText(buf);
        if (dateTime == null) {
            return CodecDateUtils.handle(context.getZeroDateOption(), false, buf, index, bytes, ROUND);
        }
        return dateTime;
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof LocalDateTime;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return new LocalDateTimeValue((LocalDateTime)value);
    }

    @Override
    public boolean doCanDecode(FieldInformation info) {
        short type = info.getType();
        return 12 == type || 7 == type || 17 == type;
    }

    @Nullable
    private static LocalDateTime decodeText(ByteBuf buf) {
        LocalDate date = LocalDateCodec.readDateText(buf);
        if (date == null) {
            return null;
        }
        LocalTime time = LocalTimeCodec.readTimeText(buf);
        return LocalDateTime.of(date, time);
    }

    @Nullable
    private static LocalDateTime decodeBinary(ByteBuf buf, int bytes) {
        LocalDate date = LocalDateCodec.readDateBinary(buf, bytes);
        if (date == null) {
            return null;
        }
        if (bytes < 7) {
            return LocalDateTime.of(date, LocalTime.MIDNIGHT);
        }
        byte hour = buf.readByte();
        byte minute = buf.readByte();
        byte second = buf.readByte();
        if (bytes < 11) {
            return LocalDateTime.of(date, LocalTime.of(hour, minute, second));
        }
        long micros = buf.readUnsignedIntLE();
        return LocalDateTime.of(date, LocalTime.of(hour, minute, second, (int)TimeUnit.MICROSECONDS.toNanos(micros)));
    }

    private static final class LocalDateTimeValue
    extends AbstractParameterValue {
        private final LocalDateTime value;

        private LocalDateTimeValue(LocalDateTime value) {
            this.value = value;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeDateTime(this.value));
        }

        @Override
        public Mono<Void> writeTo(StringBuilder builder) {
            return Mono.fromRunnable(() -> {
                builder.append('\'');
                LocalDateCodec.encodeDate(builder, this.value.toLocalDate());
                builder.append(' ');
                LocalTimeCodec.encodeTime(builder, this.value.toLocalTime());
                builder.append('\'');
            });
        }

        @Override
        public short getType() {
            return 12;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LocalDateTimeValue)) {
                return false;
            }
            LocalDateTimeValue that = (LocalDateTimeValue)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

