/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.CodecDateUtils;
import dev.miku.r2dbc.mysql.codec.DurationCodec;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import java.time.LocalTime;
import java.util.concurrent.TimeUnit;
import reactor.core.publisher.Mono;

final class LocalTimeCodec
extends AbstractClassedCodec<LocalTime> {
    private static final int HOURS_OF_DAY = 24;
    private static final int SECONDS_OF_DAY = 86400;
    private static final long NANO_OF_DAY = 86400000000000L;
    static final LocalTimeCodec INSTANCE = new LocalTimeCodec();

    private LocalTimeCodec() {
        super(LocalTime.class);
    }

    @Override
    public LocalTime decode(NormalFieldValue value, FieldInformation info, Class<? super LocalTime> target, boolean binary, ConnectionContext context) {
        if (binary) {
            return LocalTimeCodec.decodeBinary(value.getBufferSlice());
        }
        return LocalTimeCodec.readTimeText(value.getBufferSlice());
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof LocalTime;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        return new LocalTimeValue((LocalTime)value);
    }

    @Override
    public boolean doCanDecode(FieldInformation info) {
        return 11 == info.getType();
    }

    static LocalTime readTimeText(ByteBuf buf) {
        boolean isNegative = LocalTimeCodec.readNegative(buf);
        int hour = CodecDateUtils.readIntInDigits(buf);
        int minute = CodecDateUtils.readIntInDigits(buf);
        int second = CodecDateUtils.readIntInDigits(buf);
        if (isNegative) {
            long totalSeconds = -(TimeUnit.HOURS.toSeconds(hour) + TimeUnit.MINUTES.toSeconds(minute) + (long)second);
            return LocalTime.ofSecondOfDay((totalSeconds % 86400L + 86400L) % 86400L);
        }
        return LocalTime.of(hour % 24, minute, second);
    }

    static boolean readNegative(ByteBuf buf) {
        if (buf.getByte(buf.readerIndex()) == 45) {
            buf.skipBytes(1);
            return true;
        }
        return false;
    }

    private static LocalTime decodeBinary(ByteBuf buf) {
        int bytes = buf.readableBytes();
        if (bytes < 8) {
            return LocalTime.MIDNIGHT;
        }
        boolean isNegative = buf.readBoolean();
        buf.skipBytes(4);
        short hour = buf.readUnsignedByte();
        short minute = buf.readUnsignedByte();
        short second = buf.readUnsignedByte();
        if (bytes < 12) {
            if (isNegative) {
                long totalSeconds = -(TimeUnit.HOURS.toSeconds(hour) + TimeUnit.MINUTES.toSeconds(minute) + (long)second);
                return LocalTime.ofSecondOfDay((totalSeconds % 86400L + 86400L) % 86400L);
            }
            return LocalTime.of(hour % 24, minute, second);
        }
        long micros = buf.readUnsignedIntLE();
        if (isNegative) {
            long nanos = -(TimeUnit.HOURS.toNanos(hour) + TimeUnit.MINUTES.toNanos(minute) + TimeUnit.SECONDS.toNanos(second) + TimeUnit.MICROSECONDS.toNanos(micros));
            return LocalTime.ofNanoOfDay((nanos % 86400000000000L + 86400000000000L) % 86400000000000L);
        }
        return LocalTime.of(hour % 24, minute, second, (int)TimeUnit.MICROSECONDS.toNanos(micros));
    }

    static void encodeTime(StringBuilder builder, LocalTime time) {
        int micros = (int)TimeUnit.NANOSECONDS.toMicros(time.getNano());
        DurationCodec.encodeTime(builder, false, time.getHour(), time.getMinute(), time.getSecond(), micros);
    }

    private static final class LocalTimeValue
    extends AbstractParameterValue {
        private final LocalTime time;

        private LocalTimeValue(LocalTime time) {
            this.time = time;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeTime(this.time));
        }

        @Override
        public Mono<Void> writeTo(StringBuilder builder) {
            return Mono.fromRunnable(() -> {
                builder.append('\'');
                LocalTimeCodec.encodeTime(builder, this.time);
                builder.append('\'');
            });
        }

        @Override
        public short getType() {
            return 11;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LocalTimeValue)) {
                return false;
            }
            LocalTimeValue that = (LocalTimeValue)o;
            return this.time.equals(that.time);
        }

        public int hashCode() {
            return this.time.hashCode();
        }
    }
}

