/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractParameterValue;
import dev.miku.r2dbc.mysql.codec.ByteCodec;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.IntegerCodec;
import dev.miku.r2dbc.mysql.codec.PrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.ShortCodec;
import dev.miku.r2dbc.mysql.codec.TypePredicates;
import dev.miku.r2dbc.mysql.message.FieldValue;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Type;
import reactor.core.publisher.Mono;

final class LongCodec
implements PrimitiveCodec<Long> {
    static final LongCodec INSTANCE = new LongCodec();

    private LongCodec() {
    }

    @Override
    public Long decode(NormalFieldValue value, FieldInformation info, Class<? super Long> target, boolean binary, ConnectionContext context) {
        ByteBuf buf = value.getBufferSlice();
        if (binary) {
            boolean isUnsigned = (info.getDefinitions() & 0x20) != 0;
            return LongCodec.decodeBinary(buf, info.getType(), isUnsigned);
        }
        return LongCodec.parse(buf);
    }

    @Override
    public boolean canDecode(FieldValue value, FieldInformation info, Type target) {
        short type = info.getType();
        if (!(TypePredicates.isInt(type) && value instanceof NormalFieldValue && target instanceof Class)) {
            return false;
        }
        if (8 == type && (info.getDefinitions() & 0x20) != 0) {
            return Long.class == target;
        }
        return ((Class)target).isAssignableFrom(Long.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Long;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        long v = (Long)value;
        if ((long)((byte)v) == v) {
            return new ByteCodec.ByteValue((byte)v);
        }
        if ((long)((short)v) == v) {
            return new ShortCodec.ShortValue((short)v);
        }
        if ((long)((int)v) == v) {
            return new IntegerCodec.IntValue((int)v);
        }
        return new LongValue(v);
    }

    @Override
    public boolean canPrimitiveDecode(FieldInformation info) {
        return TypePredicates.isInt(info.getType());
    }

    @Override
    public Class<Long> getPrimitiveClass() {
        return Long.TYPE;
    }

    static long parse(ByteBuf buf) {
        long value;
        boolean isNegative;
        byte first = buf.readByte();
        if (first == 45) {
            isNegative = true;
            value = 0L;
        } else if (first >= 48 && first <= 57) {
            isNegative = false;
            value = (long)first - 48L;
        } else {
            isNegative = false;
            value = 0L;
        }
        while (buf.isReadable()) {
            value = value * 10L + (long)(buf.readByte() - 48);
        }
        return isNegative ? -value : value;
    }

    private static long decodeBinary(ByteBuf buf, short type, boolean isUnsigned) {
        switch (type) {
            case 8: {
                return buf.readLongLE();
            }
            case 3: {
                if (isUnsigned) {
                    return buf.readUnsignedIntLE();
                }
                return buf.readIntLE();
            }
            case 9: {
                return buf.readIntLE();
            }
            case 2: {
                if (isUnsigned) {
                    return buf.readUnsignedShortLE();
                }
                return buf.readShortLE();
            }
            case 13: {
                return buf.readShortLE();
            }
        }
        if (isUnsigned) {
            return buf.readUnsignedByte();
        }
        return buf.readByte();
    }

    private static final class LongValue
    extends AbstractParameterValue {
        private final long value;

        private LongValue(long value) {
            this.value = value;
        }

        @Override
        public Mono<Void> writeTo(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeLong(this.value));
        }

        @Override
        public Mono<Void> writeTo(StringBuilder builder) {
            return Mono.fromRunnable(() -> builder.append(this.value));
        }

        @Override
        public short getType() {
            return 8;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LongValue)) {
                return false;
            }
            LongValue longValue = (LongValue)o;
            return this.value == longValue.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }
}

