/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.ByteCodec;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.IntegerCodec;
import dev.miku.r2dbc.mysql.codec.ShortCodec;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import java.time.Year;

final class YearCodec
extends AbstractClassedCodec<Year> {
    static final YearCodec INSTANCE = new YearCodec();

    private YearCodec() {
        super(Year.class);
    }

    @Override
    public Year decode(NormalFieldValue value, FieldInformation info, Class<? super Year> target, boolean binary, ConnectionContext context) {
        if (binary) {
            return Year.of(value.getBufferSlice().readShortLE());
        }
        return Year.of(IntegerCodec.parse(value.getBufferSlice()));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Year;
    }

    @Override
    public ParameterValue encode(Object value, ConnectionContext context) {
        int year = ((Year)value).getValue();
        if ((byte)year == year) {
            return new ByteCodec.ByteValue((byte)year);
        }
        if ((short)year == year) {
            return new ShortCodec.ShortValue((short)year);
        }
        return new IntegerCodec.IntValue(year);
    }

    @Override
    public boolean doCanDecode(FieldInformation info) {
        return 13 == info.getType();
    }
}

