/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec.lob;

import dev.miku.r2dbc.mysql.codec.lob.MultiBlob;
import dev.miku.r2dbc.mysql.codec.lob.MultiClob;
import dev.miku.r2dbc.mysql.codec.lob.SingletonBlob;
import dev.miku.r2dbc.mysql.codec.lob.SingletonClob;
import dev.miku.r2dbc.mysql.message.FieldValue;
import dev.miku.r2dbc.mysql.message.LargeFieldValue;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.util.ServerVersion;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.r2dbc.spi.Blob;
import io.r2dbc.spi.Clob;

public final class LobUtils {
    public static Blob createBlob(FieldValue value) {
        int i;
        if (value instanceof NormalFieldValue) {
            ByteBuf buf = ((NormalFieldValue)value).getBufferSlice().retain();
            try {
                return new SingletonBlob(buf);
            }
            catch (Throwable e) {
                buf.release();
                throw e;
            }
        }
        ByteBuf[] buffers = ((LargeFieldValue)value).getBufferSlices();
        int size = buffers.length;
        try {
            for (i = 0; i < size; ++i) {
                buffers[i].retain();
            }
            return new MultiBlob(buffers);
        }
        catch (Throwable e) {
            for (int j = 0; j < i; ++j) {
                ReferenceCountUtil.safeRelease((Object)buffers[j]);
            }
            throw e;
        }
    }

    public static Clob createClob(FieldValue value, int collationId, ServerVersion version) {
        int i;
        if (value instanceof NormalFieldValue) {
            ByteBuf buf = ((NormalFieldValue)value).getBufferSlice().retain();
            try {
                return new SingletonClob(buf, collationId, version);
            }
            catch (Throwable e) {
                buf.release();
                throw e;
            }
        }
        ByteBuf[] buffers = ((LargeFieldValue)value).getBufferSlices();
        int size = buffers.length;
        try {
            for (i = 0; i < size; ++i) {
                buffers[i].retain();
            }
            return new MultiClob(buffers, collationId, version);
        }
        catch (Throwable e) {
            for (int j = 0; j < i; ++j) {
                ReferenceCountUtil.safeRelease((Object)buffers[j]);
            }
            throw e;
        }
    }

    private LobUtils() {
    }
}

