/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.client;

import dev.miku.r2dbc.mysql.message.client.EnvelopeClientMessage;
import dev.miku.r2dbc.mysql.message.client.HandshakeResponse;
import dev.miku.r2dbc.mysql.message.client.SslRequest320;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.CodecUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.Arrays;

final class HandshakeResponse320
extends EnvelopeClientMessage
implements HandshakeResponse {
    private final SslRequest320 head;
    private final String username;
    private final byte[] authentication;
    private final String database;

    HandshakeResponse320(int capabilities, String username, byte[] authentication, String database) {
        this.head = new SslRequest320(capabilities);
        this.username = AssertUtils.requireNonNull(username, "username must not be null");
        this.authentication = AssertUtils.requireNonNull(authentication, "authentication must not be null");
        this.database = AssertUtils.requireNonNull(database, "database must not be null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HandshakeResponse320)) {
            return false;
        }
        HandshakeResponse320 that = (HandshakeResponse320)o;
        if (!this.head.equals(that.head)) {
            return false;
        }
        if (!this.username.equals(that.username)) {
            return false;
        }
        if (!Arrays.equals(this.authentication, that.authentication)) {
            return false;
        }
        return this.database.equals(that.database);
    }

    public int hashCode() {
        int result = this.head.hashCode();
        result = 31 * result + this.username.hashCode();
        result = 31 * result + Arrays.hashCode(this.authentication);
        result = 31 * result + this.database.hashCode();
        return result;
    }

    public String toString() {
        return String.format("HandshakeResponse320{capabilities=%x, username='%s', authentication=REDACTED, database='%s'}", this.head.getCapabilities(), this.username, this.database);
    }

    @Override
    protected void writeTo(ByteBuf buf, ConnectionContext context) {
        this.head.writeTo(buf);
        Charset charset = context.getCollation().getCharset();
        CodecUtils.writeCString(buf, this.username, charset);
        if ((this.head.getCapabilities() & 8) == 0) {
            buf.writeBytes(this.authentication);
        } else {
            CodecUtils.writeCString(buf, this.authentication);
            CodecUtils.writeCString(buf, this.database, charset);
        }
    }
}

